# Build docker(2): 构建容器并发布

上一题准备了代码仓库，并且配置了对应的 Dockerfile， 现在使用 docker 命令来制作镜像：

```bash
docker image build -t cloud_native_hello_py:0.0.1 ./
```

构建如图所示：
![](./build_image.jpg)

构建镜像之后，可以将镜像发布到 DockerHub ，不过需要首先注册下账号

1. 在 <https://hub.docker.com> 上注册自己的账号
2. 使用命令 docker login 在本机登陆，输入自己的用户名和密码

现在，可以使用命令 tag 来修改镜像的标签为`用户名/镜像名`格式：

```bash
docker tag cloud_native_hello_py:0.0.1 fanfeilong/cloud_native_hello_py
```

可以用`docker image ls`验证结果

![](./build_image_tag.jpg)

现在，可以使用镜像的 push 命令来发布

```bash
docker push fanfeilong/cloud_native_hello_py:latest
```

![](./build_image_push.jpg)

以下描述错误的是？

## 答案

docker image build 构建的时候不需要指定 Dockerfile 所在目录

## 选项

### A

推送镜像需要用 `docker tag` 命令给镜像打上符合规则的标签

### B

需要在 Docker Hub 上注册账号才能用以推送镜像

### C

可以将容器镜像发布到 Docker Registry，其中 Docker Hub是官方的Docker 仓库中心
