# Build docker(1): 创建仓库

请在你自己的 [gitcode.net](https://gitcode.net) 上创建一个仓库，命名为`cloud_native_hello_py`，目录结构如下：

```bash
.
├── .dockerignore
├── .gitignore
├── Dockerfile
├── README.md
└── src
    ├── main.py
    └── requirements.txt
```

其中 main.py 文件编写一个 flask 的服务代码:

```bash
# -*- coding: UTF-8 -*-
import sys
from flask import Flask
from flask_cors import CORS
from gevent import pywsgi, monkey

monkey.patch_all()

app = Flask(
    __name__,
    static_folder='web',
    static_url_path=''
)

def after_request(resp):
    resp.headers['Access-Control-Allow-Origin'] = '*'
    return resp

app.after_request(after_request)
app.config['JSON_AS_ASCII'] = False
CORS(app, supports_credentials=True)

@app.route('/', methods=['GET'])
def home():
    return "<p>Hello World!</p>"


if __name__ == '__main__':
    host = '0.0.0.0'
    port = 1024
    print('@启动服务...')
    print("@本地调试：http://{}:{}".format(host, port))
    if len(sys.argv) > 1 and sys.argv[1] == 'debug':
        app.run(host=host, port=port)
    else:
        server = pywsgi.WSGIServer((host, port), app)
        server.serve_forever()
```

其中 requirements.txt 指定了依赖的 Python 包

```bash
Flask==2.0.3
flask_cors==3.0.10
gevent==21.1.2
```

其中 .gitignore 配置git仓库的忽略项目，而.dockerignore 则配置了构建 Docker 镜像时的忽略项

```bash
.git
.vscode
.idea
.DS_Store
__pycache__
*.pyc
*.pyo
*.pyd
.Python
*.zip
*.out
env
```

最后，我们在 Dockerfile 里编写待构建的容器镜像的配置信息

```bash
# 该镜像从官方 python:3.8 镜像继承
FROM python:3.8

# 创建 App 目录
WORKDIR /app

# 拷贝 Python 依赖配置文件
COPY src/requirements.txt ./

# 安装 Python 依赖包
RUN pip install -r requirements.txt

# 拷贝 App Python 源码到目标目录
COPY src /app

# 导出服务端口
EXPOSE 1024

# 容器启动后立刻启动 Python 服务
CMD [ "python", "main.py" ]
```

使用 git 命令将该项目代码提交到仓库。以下描述错误的是？

## 答案

Dockerfile 文件不能配置导出服务端口

## 选项

### A

Dockerfile 可以指定构建的镜像运行后立刻执行的命令

### B

Dockerfile 里可以指定构建容器镜像时，从本地文件系统里拷贝哪些目录或者文件到镜像里对应的目录

### C

Dockerfile 是构建容器镜像的配置文件
