# skill_tree_cloud_native

`云原生技能树`是[技能森林](https://gitcode.net/csdn/skill_tree)的一部分

## 初始化

```bash
pip install -r requirements.txt
```

## 目录结构说明

* 技能树`骨架文件`：
  * 位置：`data/tree.json`
  * 说明：该文件是执行 `python main.py` 生成的，请勿人工编辑
* 技能树`根节点`配置文件：
  * 位置：`data/config.json`
  * 说明：可编辑配置关键词等字段，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`难度节点`：
  * 位置：`data/xxx`，例如: `data/1.云原生初阶`
  * 说明：
    * 每个技能树有 3 个等级，目录前的序号是必要的，用来保持文件夹目录的顺序
    * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`章节点`：
  * 位置：`data/xxx/xxx`，例如：`data/1.云原生初阶/1.容器(docker)`
  * 说明：
    * 每个技能树的每个难度等级有 n 个章节，目录前的序号是必要的，用来保持文件夹目录的顺序
    * 每个目录下有一个 `config.json` 可配置关键词信息，其中 `node_id` 字段是生成的，请勿编辑
* 技能树`知识节点`：
  * 位置：`data/xxx/xxx`，例如：`data/1.云原生初阶/1.容器(docker)`
  * 说明：
    * 每个技能树的每章有 n 个知识节点，目录前的序号是必要的，用来保持文件夹目录的顺序
    * 每个目录下有一个 `config.json`
      * 其中 `node_id` 字段是生成的，请勿编辑
      * 其中 `keywords` 可配置关键字字段
      * 其中 `children` 可配置该`知识节点`下的子树结构信息，参考后面描述
      * 其中 `export` 可配置该`知识节点`下的导出习题信息，参考后面描述

## `知识节点` 子树信息结构

例如 `data/1.云原生初阶/1.容器(docker)/1.安装docker/config.json` 里配置对该知识节点子树信息结构：

```json
{
  // ...

  "children": [
    
  ],
}
```

## `知识节点` 的导出习题选项配置编辑

目前我们支持使用 markdown 语法直接编辑习题和各选项。

首先，编辑知识节点的配置，导出习题：

```json
{
  // ...
  "export": [
    "install_windows.json"
  ]
}
```

然后在 `data/1.云原生初阶/1.容器(docker)/1.安装docker/` 下增加一个`install_windows.json`定义文件：

```json
{
  "type": "code_options",
  "author": "ccat",
  "source": "install_windows.md",
  "notebook_enable": false
}
```

其中 type 字段目前都固定是 `code_options`，notebook_enable 字段决定这个习题是否生成对应的 notebook 。根据具体情况写好其它字段，注意这里 source 的文件名，我们指定了一个 markdwon 文件。现在我们新建一个 install_windows.md 并编辑为：

````mardown
# Windows下安装Docker

什么是`Docker`：

* `Docker` 将程序和程序运行所依赖的所有环境都打包到镜像里。“build once, run anywhere”
* `Docker` 是容器的一种实现。

Windows 下如何安装`Docker`:

* 官方安装教程：<https://docs.docker.com/desktop/windows/install/>
* 有两种安装套装，需要安装 WSL2 或者开启 Hyper-V and Containers 虚拟化特性。
* 注意如果你已经装了WSL，不想因为装WSL2破坏了WSL，那么最好选择“开启 Hyper-V and Containers 虚拟化特性”的这个方式。
* 无论哪种套装，安装“Docker Desktop” 并运行启动。

以下说法错误的是？

## 答案

容器只有`Docker`一种实现

## 选项

### A

Windows 上也能安装`Docker`

### B

通过构建 Docker，程序运行环境依赖的配置被极大简化

### C

Windows上安装的“Docker Desktop”可以随时卸载


````

## 技能树合成

在根目录下执行 `python main.py` 会合成技能树文件，合成的技能树文件: `data/tree.json`

* 合成过程中，会自动检查每个目录下 `config.json` 里的 `node_id` 是否存在，不存在则生成
* 合成过程中，会自动检查每个知识点目录下 `config.json` 里的 `export` 里导出的习题配置，检查是否存在`exercise_id` 字段，如果不存在则生成
