# 内联函数(1)

使用 `inline` 关键字可以标注一个函数为内联函数，但是并非所有函数都可以成为内联函数，下面正确的内联函数用法是？
可以在这里测试内联函数对应的汇编: https://godbolt.org/

## 答案

```c
#include <stdio.h>

inline int add(int x, int y){
    return x+y;
}

int main(int argc, char** args){
    printf("%d", add(0,1));
    return 0;
}
```

## 选项

### 直接定义宏字符串常量

```c
#include <stdio.h>
inline int add(int x, int y);
int add(int x, int y){
    return x+y;
}

int main(int argc, char** args){
    printf("%d", add(0,1));
    return 0;
}
```

### 两个字符串常量组合

```c
#include <stdio.h>
int add(int x, int y);
inline int add(int x, int y){
    return x+y;
}

int main(int argc, char** args){
    printf("%d", add(0,1));
    return 0;
}
```

### 宏直接拼接

```c
#include <stdio.h>
int add(int x, int y){
    return x+y;
}

int main(int argc, char** args){
    printf("%d", add(0,1));
    return 0;
}
```