# 条件编译(2)

C语言的宏定义可以通过`#ifdef`,`#else`,`#endif`包含条件编译，下面输出10的程序是？

## 答案

```c
#include <stdio.h>

#define DEBUG

int main(int argc, char** args){
    #ifdef DEBUG
        printf("%d", encode(10));
    #else
        printf("%d", encode(11));
    #endif
    return 0;
}
```

## 选项

### 直接定义宏字符串常量

```c
#include <stdio.h>

int main(int argc, char** args){
    #ifdef DEBUG
        printf("%d", encode(10));
    #else
        printf("%d", encode(11));
    #endif
    return 0;
}
```

### 两个字符串常量组合

```c
#include <stdio.h>

#define DEBUG
#undef DEBUG

int main(int argc, char** args){
    #ifdef DEBUG
        printf("%d", encode(10));
    #else
        printf("%d", encode(11));
    #endif
    return 0;
}
```

### 宏直接拼接

```c
#include <stdio.h>

#define DEBUG

int main(int argc, char** args){
    #ifdef DEBUG
        printf("%d", encode(11));
    #else
        printf("%d", encode(10));
    #endif
    return 0;
}
```