# 十六进制转换

将任意二进制数据转成16进制并打印hex字符串

## template

```c
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

$code

int main(int argc, char **argv) {
  char *str = "HelloWorld!";
  char *hex = (char *)malloc(512 * sizeof(char));
  bin_to_hex(str, strlen(str), hex);
  printf("%s", hex);
  return 0;
}
```

## 答案

```c
void bin_to_hex(const void *data, uint32_t len, char *out) {
  static const char *const lut = "0123456789abcdef";
  uint32_t i;
  for (i = 0; i < len; ++i) {
    uint8_t c = ((uint8_t *)data)[i];
    out[i * 2] = lut[c >> 4];
    out[i * 2 + 1] = lut[c & 15];
  }
}
```

## 选项

### 选项1

```c
void bin_to_hex(const void *data, uint32_t len, char *out) {
  static const char *const lut = "0123456789abcdef";
  uint32_t i;
  for (i = 0; i < len; ++i) {
    uint8_t c = ((uint8_t *)data)[i];
    out[i * 2] = lut[c >> 4];
    out[i * 2 + 1] = lut[c << 4];
  }
}
```

### 选项2

```c
void bin_to_hex(const void *data, uint32_t len, char *out) {
  static const char *const lut = "0123456789abcdef";
  uint32_t i;
  for (i = 0; i < len; ++i) {
    uint8_t c = ((uint8_t *)data)[i];
    out[i * 2] = lut[c << 4];
    out[i * 2 + 1] = lut[c & 15];
  }
}
```

### 选项3

```c
void bin_to_hex(const void *data, uint32_t len, char *out) {
  static const char *const lut = "0123456789abcdef";
  uint32_t i;
  for (i = 0; i < len; ++i) {
    uint8_t c = ((uint8_t *)data)[i];
    out[i * 2] = lut[c >> 4];
    out[i * 2 + 1] = lut[c & 16];
  }
}
```