# 八进制转换

将正整数输出为八进制形式的字符串。现已有申请内存的`create_buffer`函数和释放内存的`free_buffer`
函数，正确的字符串转换函数是：

## template

```c
#include <stdio.h>
#include <stdlib.h>

unsigned int count(unsigned int x) {
    unsigned int n = 0;
    while(x){
        x >>= 3;
        n++;
    }
    return n;
}

int create_buffer(unsigned int x, char** ref){
    unsigned int length = count(x);
    *ref = malloc(length*sizeof(char));
    return length;
}

$code

void free_buffer(char** buffer) {
    free(*buffer);
}

void print_oct(unsigned int x){
    char* oct_string = NULL;
    int len = create_buffer(x, &oct_string);
    put_oct(x, oct_string, len);
    printf("%d oct: %s \n", x, oct_string);
    free_buffer(&oct_string);
}

int main(char** args){
    print_oct(100);
    print_oct(25);
    print_oct(64);
    print_oct(15);
    return 0;
}
```

## 答案

```c
void put_oct(unsigned int x, char* buffer, int n) {
    char start = '0';
    while(x){
        n--;
        buffer[n] = start + x % 8;
        x >>= 3;
    }
}
```

## 选项

### 索引错误，会导致内存写越界

```c
void put_oct(unsigned int x, char* buffer, int n) {
    char start = '0';
    while(x){
        buffer[n] = start + x % 8;
        n--;
        x >>= 3;
    }
}
```

### 没写括号导致流程错误

```c
void put_oct(unsigned int x, char* buffer, int n) {
    char start = '0';
    while(x)
        buffer[--n] = start + x % 8;
        x >>= 3;
}
```

### 位移操作错误

```c
void put_oct(unsigned int x, char* buffer, int n) {
    char start = '0';
    while(x){
        n--;
        buffer[n] = start + x % 8;
        x >>= 8;
    }
}
```