# 数的结构判断

下列代码用于判断一个给定整数 x ，是否是 2 的正整次幂（如果是，返回1，否则返回0）。其中能正确执行的是：

## template

```c
#include <stdio.h>

$code

int main(char** args){
    printf("check(%d) return %d\n", 100, check(100));
    printf("check(%d) return %d\n", 64, check(64));
    printf("check(%d) return %d\n", 2, check(2));
    printf("check(%d) return %d\n", 32, check(32));
    return 0;
}
```


## 答案

```c

unsigned int check(unsigned int x) {
    if(x < 2){
        return 0;
    }
    return (x & (x-1)) == 0;
}

```

## 选项

### 没有考虑边界

```c

int check(int x) {
    return (x & (x-1)) == 0;
}

```

### 优先级错误

```c

unsigned int check(unsigned int x) {
    return x & (x-1) == 0;
}

```

### 边界条件处理的不对

```c
unsigned int check(unsigned int x) {
    for(int value = x; value > 0; value = value/2) {
        if((value % 2) != 0){
            return 0;
        }
    }
    return 1;
}
```