# 枚举类型

输入一个日期(年月日)，输出该日期是星期几。请选出<span style="color:red">错误</span>答案。

## 答案
```c
#include <stdio.h>

enum week {Mon, Tues, Wed, Thurs, Fri, Sat, Sun};
enum week dw;

int cal_day_of_week(int y, int m, int d)
{
    int dw;
    if (m == 1 || m == 2)
    {
        m += 12;
        y--;
    }
    dw = (d + 2 * m + 3 * (m + 1) / 5 + y + y / 4 - y / 100 + y / 400) % 7;
    return dw;
}

int main(int argc, char** argv)
{
    int year, month, day;
    printf("请输入日期(年-月-日)：\n");
    scanf("%d-%d-%d", &year, &month, &day);
    dw = cal_day_of_week(year, month, day);
    switch (dw)
    {
        case week.Mon: printf("星期一\n"); break;
        case week.Tues: printf("星期二\n"); break;
        case week.Wed: printf("星期三\n"); break;
        case week.Thurs: printf("星期四\n"); break;
        case week.Fri: printf("星期五\n"); break;
        case week.Sat: printf("星期六\n"); break;
        case week.Sun: printf("星期日\n"); break;
    }

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>

enum week {Mon, Tues, Wed, Thurs, Fri, Sat, Sun};
enum week dw;

int cal_day_of_week(int y, int m, int d)
{
    int dw;
    if (m == 1 || m == 2)
    {
        m += 12;
        y--;
    }
    dw = (d + 2 * m + 3 * (m + 1) / 5 + y + y / 4 - y / 100 + y / 400) % 7;
    return dw;
}

int main(int argc, char** argv)
{
    int year, month, day;
    printf("请输入日期(年-月-日)：\n");
    scanf("%d-%d-%d", &year, &month, &day);
    dw = cal_day_of_week(year, month, day);
    switch (dw)
    {
        case Mon: printf("星期一\n"); break;
        case Tues: printf("星期二\n"); break;
        case Wed: printf("星期三\n"); break;
        case Thurs: printf("星期四\n"); break;
        case Fri: printf("星期五\n"); break;
        case Sat: printf("星期六\n"); break;
        case Sun: printf("星期日\n"); break;
    }

    return 0;
}
```

### B
```c
#include <stdio.h>

enum week {Mon=0, Tues=1, Wed=2, Thurs=3, Fri=4, Sat=5, Sun=6};
enum week dw;

int cal_day_of_week(int y, int m, int d)
{
    int dw;
    if (m == 1 || m == 2)
    {
        m += 12;
        y--;
    }
    dw = (d + 2 * m + 3 * (m + 1) / 5 + y + y / 4 - y / 100 + y / 400) % 7;
    return dw;
}

int main(int argc, char** argv)
{
    int year, month, day;
    printf("请输入日期(年-月-日)：\n");
    scanf("%d-%d-%d", &year, &month, &day);
    dw = cal_day_of_week(year, month, day);
    switch (dw)
    {
        case Mon: printf("星期一\n"); break;
        case Tues: printf("星期二\n"); break;
        case Wed: printf("星期三\n"); break;
        case Thurs: printf("星期四\n"); break;
        case Fri: printf("星期五\n"); break;
        case Sat: printf("星期六\n"); break;
        case Sun: printf("星期日\n"); break;
    }

    return 0;
}

```

### C
```c
#include <stdio.h>

enum week {Mon=0, Tues, Wed, Thurs, Fri, Sat, Sun};
enum week dw;

int cal_day_of_week(int y, int m, int d)
{
    int dw;
    if (m == 1 || m == 2)
    {
        m += 12;
        y--;
    }
    dw = (d + 2 * m + 3 * (m + 1) / 5 + y + y / 4 - y / 100 + y / 400) % 7;
    return dw;
}

int main(int argc, char** argv)
{
    int year, month, day;
    printf("请输入日期(年-月-日)：\n");
    scanf("%d-%d-%d", &year, &month, &day);
    dw = cal_day_of_week(year, month, day);
    switch (dw)
    {
        case Mon: printf("星期一\n"); break;
        case Tues: printf("星期二\n"); break;
        case Wed: printf("星期三\n"); break;
        case Thurs: printf("星期四\n"); break;
        case Fri: printf("星期五\n"); break;
        case Sat: printf("星期六\n"); break;
        case Sun: printf("星期日\n"); break;
    }

    return 0;
}

```
