# 结构体数组

定义一个学生结构体，并实例化一个结构体数组，用于保存一个班级所有学生的基本信息，最后输出所有学生基本信息，以及班级的学生平均成绩。请选出<span style="color:red">错误</span>答案。

## 答案
```c
#include <stdio.h>
#define NUM_STR 3

struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
} cls[NUM_STR];

int main(int argc, char** argv)
{
    cls = {
        {"张三", 1001, 16, 'A', 95.50},
        {"李四", 1002, 15, 'A', 90.00},
        {"王五", 1003, 16, 'B', 80.50}
    };
    
    float total = 0, average = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (int i = 0; i < NUM_STR; ++i) {
        printf("%s\t%d\t%d\t%c\t%.2f\n", 
            cls[i].name, cls[i].id, cls[i].age, cls[i].group, cls[i].score);
        total += cls[i].score;
    }
    printf("============================================\n");
    average = total / NUM_STR;
    printf("班级平均成绩：%.2f", average);

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>

struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
} cls[] = {
    {"张三", 1001, 16, 'A', 95.50},
    {"李四", 1002, 15, 'A', 90.00},
    {"王五", 1003, 16, 'B', 80.50}
};

int main(int argc, char** argv)
{
    size_t i, num_stu = sizeof(cls) / sizeof(struct Student);
    float total = 0, average = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (i = 0; i < num_stu; ++i) {
        printf("%s\t%d\t%d\t%c\t%.2f\n", 
            cls[i].name, cls[i].id, cls[i].age, cls[i].group, cls[i].score);
        total += cls[i].score;
    }
    printf("============================================\n");
    average = total / num_stu;
    printf("班级平均成绩：%.2f", average);

    return 0;
}
```

### B
```c
#include <stdio.h>

struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
} cls[] = {
    "张三", 1001, 16, 'A', 95.50,
    "李四", 1002, 15, 'A', 90.00,
    "王五", 1003, 16, 'B', 80.50
};

int main(int argc, char** argv)
{
    size_t i, num_stu = sizeof(cls) / sizeof(struct Student);
    float total = 0, average = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (i = 0; i < num_stu; ++i) {
        printf("%s\t%d\t%d\t%c\t%.2f\n", 
            cls[i].name, cls[i].id, cls[i].age, cls[i].group, cls[i].score);
        total += cls[i].score;
    }
    printf("============================================\n");
    average = total / num_stu;
    printf("班级平均成绩：%.2f", average);

    return 0;
}
```

### C
```c
#include <stdio.h>

struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
} cls[] = {
    {.name = "张三", .group = 'A', .age = 16, .score = 95.50, .id = 1001},
    {.age = 15, .score = 90.00, .group = 'A', .id = 1002, .name = "李四"},
    {.group = 'B', .age = 16, .name = "王五", .score = 80.50, .id = 1003}
};

int main(int argc, char** argv)
{
    size_t i, num_stu = sizeof(cls) / sizeof(struct Student);
    float total = 0, average = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (i = 0; i < num_stu; ++i) {
        printf("%s\t%d\t%d\t%c\t%.2f\n", 
            cls[i].name, cls[i].id, cls[i].age, cls[i].group, cls[i].score);
        total += cls[i].score;
    }
    printf("============================================\n");
    average = total / num_stu;
    printf("班级平均成绩：%.2f", average);

    return 0;
}
```
