# 字符串函数的使用

比较词序列，并替换其中的指定词，最后将所有词拼接形成一个新的句子。程序的输出如下：<br/>
<font size="2">
<div style="text-indent:2em;">替换前：</div>
<div style="text-indent:2em;">非淡泊无以明志！</div>
<div style="text-indent:2em;">替换后：</div>
<div style="text-indent:2em;">非宁静无以致远！</div>
</font><br/>
请选出<span style="color:red">正确</span>答案。
<br/>

## 答案
```c
#include <stdio.h>
#include <string.h>
#define SENT_LEN 5
#define WORDS_NUM 2
#define STR_LEN 101

int main(int argc, char** argv)
{
    int i, j;
    char words[SENT_LEN][STR_LEN] = {"非", "淡泊", "无以", "明志", "！"};
    char source[WORDS_NUM][STR_LEN] = {"淡泊", "明志"};
    char target[WORDS_NUM][STR_LEN] = {"宁静", "致远"};
    char sentence_before[STR_LEN];
    char sentence_after[STR_LEN];
    
    for (i = 0; i < SENT_LEN; ++i)
    {
        strcat(sentence_before, words[i]);
        for (j = 0; j < WORDS_NUM; ++j)
            if (strcmp(words[i], source[j]) == 0)
                strcpy(words[i], target[j]);
        strcat(sentence_after, words[i]);
    }
    
    puts("替换前：");
    puts(sentence_before);
    puts("替换后：");
    puts(sentence_after);

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>
#include <string.h>
#define SENT_LEN 5
#define WORDS_NUM 2
#define STR_LEN 101

int main(int argc, char** argv)
{
    int i, j;
    char words[SENT_LEN][STR_LEN] = {"非", "淡泊", "无以", "明志", "！"};
    char source[WORDS_NUM][STR_LEN] = {"淡泊", "明志"};
    char target[WORDS_NUM][STR_LEN] = {"宁静", "致远"};
    char sentence_before[STR_LEN];
    char sentence_after[STR_LEN];
    
    for (i = 0; i < SENT_LEN; ++i)
    {
        strcat(sentence_before, words[i]);
        for (j = 0; j < WORDS_NUM; ++j)
            if (strcmp(words[i], source[j]) >= 0)
                strcpy(words[i], target[j]);
        strcat(sentence_after, words[i]);
    }

    puts("替换前：");
    puts(sentence_before);
    puts("替换后：");
    puts(sentence_after);

    return 0;
}
```

### B
```c
#include <stdio.h>
#include <string.h>
#define SENT_LEN 5
#define WORDS_NUM 2
#define STR_LEN 101

int main(int argc, char** argv)
{
    int i, j;
    char* words[SENT_LEN] = {"非", "淡泊", "无以", "明志", "！"};
    char* source[WORDS_NUM] = {"淡泊", "明志"};
    char* target[WORDS_NUM] = {"宁静", "致远"};
    char sentence_before[STR_LEN];
    char sentence_after[STR_LEN];
    
    for (i = 0; i < SENT_LEN; ++i)
    {
        strcat(sentence_before, words[i]);
        for (j = 0; j < WORDS_NUM; ++j)
            if (strcmp(words[i], source[j]) == 0)
                strcpy(words[i], target[j]);
        strcat(sentence_after, words[i]);
    }

    puts("替换前：");
    puts(sentence_before);
    puts("替换后：");
    puts(sentence_after);

    return 0;
}
```

### C
```c
#include <stdio.h>
#include <string.h>
#define SENT_LEN 5
#define WORDS_NUM 2
#define STR_LEN 101

int main(int argc, char** argv)
{
    int i, j;
    char words[SENT_LEN][STR_LEN] = {"非", "淡泊", "无以", "明志", "！"};
    char source[WORDS_NUM][STR_LEN] = {"淡泊", "明志"};
    char target[WORDS_NUM][STR_LEN] = {"宁静", "致远"};
    const char sentence_before[STR_LEN];
    const char sentence_after[STR_LEN];
    
    for (i = 0; i < SENT_LEN; ++i)
    {
        strcat(sentence_before, words[i]);
        for (j = 0; j < WORDS_NUM; ++j)
            if (strcmp(words[i], source[j]) == 0)
                strcpy(words[i], target[j]);
        strcat(sentence_after, words[i]);
    }
    
    puts("替换前：");
    puts(sentence_before);
    puts("替换后：");
    puts(sentence_after);

    return 0;
}
```
