# 矩阵转置

基于二维数组实现矩阵转置，以下选项对应(1)处缺失的代码，请判断哪一项<span style="color:red">无法</span>实现矩阵转置。<br/>

```c
#include <stdio.h>
#define LEN 101

void print_matrix(int mat[][LEN], int row, int col)
{
    for (int i = 0; i < row; ++i)
    {
        for (int j = 0; j < col; ++j)
            printf("%d\t", mat[i][j]);
        printf("\n");
    }
}

int main(int argc, char** argv)
{
    int i, j, row, col, num, m[LEN][LEN], t[LEN][LEN];

    printf("请输入矩阵的行数(<=100)：");
    scanf("%d", &row);
    printf("请输入矩阵的列数(<=100)：");
    scanf("%d", &col);
    num = row * col;
    printf("请输入矩阵的元素(共%d个，空格分隔)：\n", num);
    for (i = 0; i < row; ++i)
        for (j = 0; j < col; ++j)
            scanf("%d", &m[i][j]);

    printf("转置前：\n");
    print_matrix(m, row, col);

    (_____1_____)

    printf("转置后：\n");
    print_matrix(t, col, row);

    return 0;
}
```

<font size="2">
矩阵转置图示：
<div style="text-indent:2em;"><img src="https://img-community.csdnimg.cn/images/3891b6d96b914b699df369d769483bff.png"  alt="矩阵转置图示" width="390"/></div>
</font>
<br/>

## template

```c
#include <stdio.h>
#define LEN 101

void print_matrix(int mat[][LEN], int row, int col)
{
    for (int i = 0; i < row; ++i)
    {
        for (int j = 0; j < col; ++j)
            printf("%d\t", mat[i][j]);
        printf("\n");
    }
}

int main(int argc, char** argv)
{
    int i, j, row, col, num, m[LEN][LEN], t[LEN][LEN];

    printf("请输入矩阵的行数(<=100)：");
    scanf("%d", &row);
    printf("请输入矩阵的列数(<=100)：");
    scanf("%d", &col);
    num = row * col;
    printf("请输入矩阵的元素(共%d个，空格分隔)：\n", num);
    for (i = 0; i < row; ++i)
        for (j = 0; j < col; ++j)
            scanf("%d", &m[i][j]);

    printf("转置前：\n");
    print_matrix(m, row, col);

    for (i = 0; i < row; ++i)
        for (j = 0; j < col; ++j)
            t[j][i] = m[i][j];

    printf("转置后：\n");
    print_matrix(t, col, row);

    return 0;
}
```

## 答案

```c
    for (i = 1; i <= row; ++i)
        for (j = 1; j <= col; ++j)
            *(*(t + j) + i) = *(*(m + i) + j);
```

## 选项

### A
```c
    for (i = 0; i < row; ++i)
        for (j = 0; j < col; ++j)
            t[j][i] = m[i][j];
```

### B

```c
    for (i = 0; i < row * col; ++i)
        t[i / row][i % row] = m[i % row][i / row];
```

### C

```c
    for (i = row - 1; i >= 0; --i)
        for (j = col - 1; j >= 0; --j)
            t[j][i] = m[i][j];
```

