# 简单选择排序

定义选择排序和使用选择排序分别在不同的文件中，其中包含了内部函数与外部函数。请选出不能正确实现升序排序的选项。

## 答案
```c
// ssort.c
#include <stdio.h>

static void swap(int *a,int *b)
{
    int temp = *a;
    *a = *b;
    *b = temp;
}

static void print_array(int array[], int len)
{
    for (int i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

extern void selection_sort(int array[], int len) 
{
    int i,j,temp,min;
 
    for (i = 0 ; i < len - 1 ; ++i) 
    {
        min = i;
        for (j = i + 1; j < len; ++j)
            if (array[j] < array[min])
                min = j;
        if(min != i)
            swap(&array[min], &array[i]);
    }
}

//ex_in_function.c
#include <stdio.h>
#define ARR_LEN 10

void selection_sort(int array[], int len);
void print_array(int array[], int len);

int main()
{
    int i;
    int array[ARR_LEN] = {8, 1, 4, 10, 3, 6, 2, 7, 9, 5};
    
    printf("排序前：\n");
    print_array(array, ARR_LEN);
    selection_sort(array, ARR_LEN);
    printf("排序后：\n");
    print_array(array, ARR_LEN);

    return 0;
}
```

## 选项
### A
```c
// ssort.c
#include <stdio.h>

static void swap(int *a,int *b)
{
    int temp = *a;
    *a = *b;
    *b = temp;
}

extern void selection_sort(int array[], int len) 
{
    int i,j,temp,min;
 
    for (i = 0 ; i < len - 1 ; ++i) 
    {
        min = i;
        for (j = i + 1; j < len; ++j)
            if (array[j] < array[min])
                min = j;
        if(min != i)
            swap(&array[min], &array[i]);
    }
}

// ex_in_function.c
#include <stdio.h>
#define ARR_LEN 10

void selection_sort(int array[], int len);

static void print_array(int array[], int len)
{
    for (int i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

int main()
{
    int i;
    int array[ARR_LEN] = {8, 1, 4, 10, 3, 6, 2, 7, 9, 5};
    
    printf("排序前：\n");
    print_array(array, ARR_LEN);
    selection_sort(array, ARR_LEN);
    printf("排序后：\n");
    print_array(array, ARR_LEN);

    return 0;
}
```

### B
```c
// ssort.c
#include <stdio.h>

void print_array(int array[], int len);

static void swap(int *a,int *b)
{
    int temp = *a;
    *a = *b;
    *b = temp;
}

extern void selection_sort(int array[], int len) 
{
    int i,j,temp,min;
 
    printf("排序前：\n");
    print_array(array, len);
    for (i = 0 ; i < len - 1 ; ++i) 
    {
        min = i;
        for (j = i + 1; j < len; ++j)
            if (array[j] < array[min])
                min = j;
        if(min != i)
            swap(&array[min], &array[i]);
    }

    printf("排序后：\n");
    print_array(array, len);
}

// ex_in_function.c
#include <stdio.h>
#define ARR_LEN 10

void selection_sort(int array[], int len);

extern void print_array(int array[], int len)
{
    for (int i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

int main()
{
    int i;
    int array[ARR_LEN] = {8, 1, 4, 10, 3, 6, 2, 7, 9, 5};
    selection_sort(array, ARR_LEN);

    return 0;
}
```

### C
```c
// ssort.c
#include <stdio.h>

void print_array(int array[], int len);

static void swap(int *a,int *b)
{
    int temp = *a;
    *a = *b;
    *b = temp;
}

void selection_sort(int array[], int len) 
{
    int i,j,temp,min;
 
    printf("排序前：\n");
    print_array(array, len);
    for (i = 0 ; i < len - 1 ; ++i) 
    {
        min = i;
        for (j = i + 1; j < len; ++j)
            if (array[j] < array[min])
                min = j;
        if(min != i)
            swap(&array[min], &array[i]);
    }

    printf("排序后：\n");
    print_array(array, len);
}

// ex_in_function.c
#include <stdio.h>
#define ARR_LEN 10

void selection_sort(int array[], int len);

void print_array(int array[], int len)
{
    for (int i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

int main()
{
    int i;
    int array[ARR_LEN] = {8, 1, 4, 10, 3, 6, 2, 7, 9, 5};
    selection_sort(array, ARR_LEN);

    return 0;
}
```
