# 英文字母判断

判断一个字符是否是英文字母。请判断以下选项中哪个条件<span style="color:red">不能</span>填在(1)处。

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    char ch;
    printf("请输入一个字符：");
    scanf("%c", &ch);

    if (_____(1)_____)
        printf("字符 \'%c\' 是一个英文字母", ch);
    else
        printf("字符 \'%c\' 不是一个英文字母", ch);

    return 0;
}
```

下图是ASCII表，ASCII（American Standard Code for Information Interchange，美国标准信息交换代码）是基于拉丁字母的一套电脑编码系统，主要用于显示现代英语和其他西欧语言。它是现今最通用的单字节编码系统，并等同于国际标准ISO/IEC 646。
<br/>
![](https://img-blog.csdnimg.cn/20200728090157350.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3dlaXhpbl80NTY2MzkwNQ==,size_16,color_FFFFFF,t_70/resize,p_50)
<br/>

## template

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    char ch;
    printf("请输入一个字符：");
    scanf("%c", &ch);

    if ($code)
        printf("字符 \'%c\' 是一个英文字母", ch);
    else
        printf("字符 \'%c\' 不是一个英文字母", ch);

    return 0;
}
```

## 答案

```c
('a' <= ch <= 'z') || ('A' <= ch <= 'Z')
```

## 选项

### A

```c
(ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z')
```

### B

```c
(ch >= 97 && ch <= 122) || (ch >= 65 && ch <= 90)
```

### C

```c
(0 <= (ch - 'a') && (ch - 'a') < 26) || (0 <= (ch - 'A') && (ch - 'A') < 26)
```
