# 变量：求正整数的平方

使用while循环修改变量值，依次打印10以内(包含10)所有正整数的平方。程序执行的第一步需要定义合适的变量用于后续逻辑的实现，请选出<span style="color:red">正确</span>的变量定义，填在以下代码的(1)处。<br/><br/>

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    (_____1_____)

    while (num <= max_num)
    {
        result = num * num;
        printf("%d ^ 2 = %d\n", num, result);
        num = num + step;
    }

    return 0;
}
```

<font size="2">
小知识：C语言变量的生命周期和作用域<br/>
<table border="1">
  <tr>
    <th>变量类型</th>
    <th bgcolor="lightyellow">生存周期</th>
    <th bgcolor="lightyellow">作用域</th>
  </tr>
  <tr>
    <td rowspan="3" bgcolor="lightblue">局部变量</td>
    <td>auto：自动变量，离开定义函数立即消失</td>
    <td rowspan="3">只作用于该函数内部</td>
  </tr>
  <tr>
    <td>register：寄存器变量，离开定义函数立即消失</td>
  </tr>
  <tr>
    <td>static：静态变量，离开定义函数仍然存在</td>
  </tr>
  <tr>
    <td rowspan="2" bgcolor="lightblue">全局变量</td>
    <td rowspan="2">在程序运行期间一直存在</td>
    <td>static：静态变量，仅限于本文件内部条用</td>
  </tr>
  <tr>
    <td>extern：外部存储变量，用于声明本文件将要用到的其他文件的变量</td>
  </tr>
</table>
</font>
<br/>


## template

```c
#include <stdio.h>

int main(int argc, char** argv)
{
$code

    while (num <= max_num)
    {
        result = num * num;
        printf("%d ^ 2 = %d\n", num, result);
        num = num + step;
    }

    return 0;
}
```

## 答案
```c
    int num = 1;
    int max_num = 10;
    int step = 1;
    int result = 0;
```

## 选项

### A

```c
    num = 1;
    max_num = 10;
    step = 1;
    result = 0;
```

### B

```c
    int num(1);
    int max_num(10);
    int step(1);
    int result(0);
```

### C

```c
    float num = 1;
    float max_num = 10;
    float step = 1;
    float result = 0;
```

