# 了解有哪几个C标准

下列哪个不是C标准。参考：<a href="https://iso-9899.info/wiki/The_Standard">C语言标准</a><br/><br/>
<font size="2">
小知识：C语言标准的发展
<div style="text-indent:2em;"><font color="green">K&R C</font>: 1978年，丹尼斯·里奇(Dennis Ritchie)和布莱恩·科尔尼干(Brian Kernighan)出版了一本书，名叫《The C Programming Language》。这本书被C语言开发者们称为“K&R”，很多年来被当作C语言的非正式的标准说明。人们称这个版本的C语言为“K&R C”。</div>
<div style="text-indent:2em;"><font color="green">C89</font>: 为统一C语言版本，1983年美国国家标准局（American National Standards Institute，简称ANSI）成立了一个委员会，来制定C语言标准。1989年C语言标准被批准，被称为ANSI X3.159-1989 “Programming Language C”。这个版本的C语言标准通常被称为ANSI C。又由于这个版本是 89年完成制定的，因此也被称为C89。</div>
<div style="text-indent:2em;"><font color="green">C90</font>: 后来ANSI把这个标准提交到ISO（国际化标准组织），1990年被ISO采纳为国际标准，称为ISO C。又因为这个版本是1990年发布的，因此也被称为C90。所以ANSI C、ISO C、C89、C90这4个标准的内容其实是一样的。</div>
<div style="text-indent:2em;"><font color="green">C99</font>: 在ANSI C标准确立之后，C语言的规范在很长一段时间内都没有大的变动。1995年C程序设计语言工作组对C语言进行了一些修改，成为后来的1999年发布的ISO/IEC 9899:1999标准，通常被成为C99。但是各个公司对C99的支持所表现出来的兴趣不同。当GCC和其它一些商业编译器支持C99的大部分特性的时候，微软和Borland却似乎对此不感兴趣。</div>
<div style="text-indent:2em;"><font color="green">C11</font>: 在2011年12月，ANSI采纳了ISO/IEC 9899:2011标准，这个标准通常即C11。</div>
<div style="text-indent:2em;"><font color="green">C18</font>: 2018年6月发布的ISO/IEC 9899:2018标准，这个标准被称为C18，是目前最新的C语言编程标准，该标准主要是对C11进行了补充和修正，并没有引入新的语言特性。</div>
<div style="text-indent:2em;"><font color="green">C2x</font>: 下一个版本的C语言标准，预计将于2022年12月1日完成。</div>
</font>
<br/>

## template

```c
#include <stdio.h>
int main(int argc, char** argc){
    printf("这是一个C标准代号：%d", "C89");
    printf("这是一个C标准代号：%d", "C90");
    printf("这是一个C标准代号：%d", "C95");
    printf("这是一个C标准代号：%d", "C99");
    printf("这是一个C标准代号：%d", "C11");
    printf("这是一个C标准代号：%d", "C18");
    return 0;
}
```

## 答案
```c
#include <stdio.h>
int main(int argc, char** argv){
    printf("这是一个C标准代号：%s", "C19");
    return 0;
}
```

## 选项

### A

```c
#include <stdio.h>
int main(int argc, char** argv){
    printf("这是一个C标准代号：%s", "C11");
    return 0;
}
```

### B

```c
#include <stdio.h>
int main(int argc, char** argv){
    printf("这是一个C标准代号：%s", "C18");
    return 0;
}
```

### C

```c
#include <stdio.h>
int main(int argc, char** argv){
    printf("这是一个C标准代号：%s", "C99");
    return 0;
}
```


