# 统计函数调用次数

正确输出 **func_1()** 函数在当前程序中为第几次被调用。请选出<span style="color:red">错误</span>答案。

## 答案
```c
#include <stdio.h>

void func_1()
{
    int num = 0;
    ++num;
    printf("第%d次调用函数func_1()\n", num);
}

void func_2()
{
    func_1();
}

void func_3()
{
    func_1();
    func_2();
}

int main(int argc, char** argv)
{
    func_1();
    func_2();
    func_3();

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>

int num = 0;

void func_1()
{
    ++num;
    printf("第%d次调用函数func_1()\n", num);
}

void func_2()
{
    func_1();
}

void func_3()
{
    func_1();
    func_2();
}

int main(int argc, char** argv)
{
    func_1();
    func_2();
    func_3();

    return 0;
}
```

### B
```c
#include <stdio.h>

void func_1()
{
    static int num = 0;
    ++num;
    printf("第%d次调用函数func_1()\n", num);
}

void func_2()
{
    func_1();
}

void func_3()
{
    func_1();
    func_2();
}

int main(int argc, char** argv)
{
    func_1();
    func_2();
    func_3();

    return 0;
}
```

### C
```c
#include <stdio.h>

void func_1(int *num)
{
    printf("第%d次调用函数func_1()\n", *num);
    ++(*num);
}

void func_2(int *num)
{
    func_1(num);
}

void func_3(int *num)
{
    func_1(num);
    func_2(num);
}

int main(int argc, char** argv)
{
    int num = 1;

    func_1(&num);
    func_2(&num);
    func_3(&num);

    return 0;
}
```
