# 条件编译(1)

C语言的宏定义可以通过`#ifdef`,`#else`,`#endif`包含条件编译，下面输出11的程序是？

## 答案

```c
#include <stdio.h>

#define add_encode(x) x+1
#define sub_encode(x) x-1
#define unit_encode(x) x


#define USE_INC

#ifdef USE_INC
    #define encode add_encode
#else
    #ifdef USE_SUB
        #define encode sub_encode
    #else
        #define encode unit_encode
    #endif
#endif

int main(int argc, char** args){
    printf("%d", encode(10));
    return 0;
}
```

## 选项

### 直接定义宏字符串常量

```c
#include <stdio.h>

#define add_encode(x) x+1
#define sub_encode(x) x-1
#define unit_encode(x) x


#define USE_SUB

#ifdef USE_INC
    #define encode add_encode
#else
    #ifdef USE_SUB
        #define encode sub_encode
    #else
        #define encode unit_encode
    #endif
#endif

int main(int argc, char** args){
    printf("%d", encode(10));
    return 0;
}
```

### 两个字符串常量组合

```c
#include <stdio.h>

#define add_encode(x) x+1
#define sub_encode(x) x-1
#define unit_encode(x) x


#define USE_UNIT

#ifdef USE_INC
    #define encode add_encode
#else
    #ifdef USE_SUB
        #define encode sub_encode
    #else
        #define encode unit_encode
    #endif
#endif

int main(int argc, char** args){
    printf("%d", encode(10));
    return 0;
}
```

### 宏直接拼接

```c
#include <stdio.h>

#define add_encode(x) x+1
#define sub_encode(x) x-1
#define unit_encode(x) x

#ifdef USE_INC
    #define encode add_encode
#else
    #ifdef USE_SUB
        #define encode sub_encode
    #else
        #define encode unit_encode
    #endif
#endif

int main(int argc, char** args){
    printf("%d", encode(10));
    return 0;
}
```