# 使用 `#undef`

C语言的宏定义可以通过`#undef`取消定义，下面程序的输出是哪个选项？

```c
#include <stdio.h>

#define next(x) x+1
#undef next

int main(int argc, char** args){
    printf("%d", next(10));
    return 0;
}
```

## 答案

```c
error: use of undeclared identifier 'next'
```

## 选项

### 直接定义宏字符串常量

```c
10
```

### 两个字符串常量组合

```c
11
```

### 宏直接拼接

```c
12
```