# 计算位数

计算整数的二进制形式有多少位。

## template

```c
#include <stdio.h>

$code

int main(char** args){
    printf("bits(%d) has %d bits\n", 100, bits(100));
    printf("bits(%d) has %d bits\n", 32, bits(32));
    printf("bits(%d) has %d bits\n", 10, bits(10));
    printf("bits(%d) has %d bits\n", 25, bits(25));
    printf("bits(%d) has %d bits\n", 7, bits(7));
    return 0;
}
```

## 答案

```c
unsigned int bits(unsigned int x){
    unsigned int n = 0;
    while(x){
        x >>= 1;
        n++;
    }
    return n;
}
```

## 选项

### 位移计算没有保存

```c
unsigned int bits(unsigned int x){
    unsigned int n = 0;
    while(x){
        x >> 1;
        n++;
    }
    return n;
}
```

### 没有括号导致流程错误

```c
unsigned int bits(unsigned int x){
    unsigned int n = 0;
    while(x)
        x >>= 1;
        n++;

    return n;
}
```

### 运算符错误

```c
unsigned int bits(unsigned int x){
    unsigned int n = 0;
    while(x){
        x << 1;
        n++;
    }
    return n;
}
```