# 判断闰年

输入任意年份的正整数n，判断该年份是否为闰年。请选出<span style="color:red">错误</span>答案。<br/><br/>

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    int year;
    printf("请输人年份：");
    scanf("%d", &year);
    is_leap_year(year);

    return 0;
}
```

<font size="2">
闰年的定义：
<div style="text-indent:2em;">1. 能被400整除的年份为闰年。</div>
<div style="text-indent:2em;">2. 能被4整除同时不能被100整除年份为闰年。</div>
<br/>
闰年的由来：
<div style="text-indent:2em;">闰年（Leap Year）是为了弥补因人为历法规定造成的年度天数与地球实际公转周期的时间差而设立的。补上时间差的年份为闰年。闰年共有366天（1月~12月分别为31天、29天、31天、30天、31天、30天、31天、31天、30天、31天、30天、31天）。</div>
<div style="text-indent:2em;">闰年一年的时间为：366天，2月份有29天。</div>
<div style="text-indent:2em;">平年一年的时间为：365天，2月份有28天。</div>
<div style="text-indent:2em;">闰年与所有年份之间的集合关系如下(黄色部分为闰年)：</div><br/>
<div style="text-indent:2em;"><img src="https://img-community.csdnimg.cn/images/5630e63b0f7e463a92abc43fb63aad36.jpg"  alt="闰年的集合关系" width="390"/></div>
<br/>
逻辑表达式简介：
<div style="text-indent:2em;">假设两个整型数为 operand1 = 1, operand2 = 0</div><br/>
<table border="1">
  <tr bgcolor="lightyellow">
    <th>逻辑运算符</th>
    <th>说明</th>
    <th>示例</th>
  </tr>
  <tr>
    <td>&&</td>
    <td>如果两个操作数均为非0，则表达式的值为1，反之为0</td>
    <td>operand1 && operand2 的值为 0</td>
  </tr>
  <tr>
    <td>||</td>
    <td>如果两个操作数至少有一个为非0，则表达式的值为1，反之为0</td>
    <td>operand1 || operand2 的值为 1</td>
  </tr>
  <tr>
    <td>!</td>
    <td>如果操作数的值为非0，则表达式的值为0，反之亦反</td>
    <td>!operand1 的值为 0</td>
  </tr>
</table>
</font>
<br/>

## template

```c
#include <stdio.h>

$code

int main(int argc, char** argv)
{
    int year;
    printf("请输人年份：");
    scanf("%d", &year);
    is_leap_year(year);

    return 0;
}
```

## 答案

```c
void is_leap_year(int year)
{
    if (year % 400 == 0)
        printf("%d 此年是闰年\n", year);
    else
    {
        if (year % 4 == 0 || year % 100 != 0)
            printf("%d 是闰年\n", year);
        else
            printf("%d 非闰年\n", year);
    }
}
```

## 选项

### B
```c
void is_leap_year(int year)
{
    if (year % 400 == 0)
        printf("%d 此年是闰年\n", year);
    else
    {
        if (year % 4 == 0 && year % 100 != 0)
            printf("%d 是闰年\n", year);
        else
            printf("%d 非闰年\n", year);
    }
}
```

### C
```c
void is_leap_year(int year)
{
    if (year % 400 == 0)
        printf("%d 此年是闰年\n", year);
    else
    {
        if (!(year % 4 != 0) && !(year % 100 == 0))
            printf("%d 是闰年\n", year);
        else
            printf("%d 非闰年\n", year);
    }
}
```

### D
```c
void is_leap_year(int year)
{
    if (year % 400 == 0 || (year % 4 == 0 && year % 100 != 0))
        printf("%d 是闰年\n", year);
    else
        printf("%d 非闰年\n", year);
}
```
