# 安全问题的检查

请从下列选项中选出存在潜在安全问题的程序。

## 答案
```c
#include <stdio.h>
#include <stdlib.h>
#define N 10

void *mem_cpy(void *dest, const void *src, size_t len)
{
    char *tmp_dest = (char *)dest;
    char *tmp_src = (char *)src;
    while(len --)
        *tmp_dest ++ = *tmp_src ++;
    return dest;
}

int main(int argc, char** argv)
{
    int *dest = NULL;
    int *src = (int *)malloc(N * sizeof(int));
    dest = mem_cpy(dest, src, N);

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define N 10

void *mem_cpy(void *dest, const void *src, size_t len)
{
    if(dest == NULL)
    {
        fprintf(stderr,"dest is NULL\n");
        abort();
    }
    if(src == NULL)
    {
        fprintf(stderr,"src is NULL\n");
        abort();
    }
    char *tmp_dest = (char *)dest;
    char *tmp_src = (char *)src;
    while(len --)
        *tmp_dest ++ = *tmp_src ++;
    return dest;
}

int main(int argc, char** argv)
{
    int *dest = NULL;
    int *src = (int *)malloc(N * sizeof(int));
    dest = mem_cpy(dest, src, N);

    return 0;
}
```

### B
```c
#include <stdio.h>
#include <stdlib.h>
#define N 10
#define DEBUG

void *mem_cpy(void *dest, const void *src, size_t len)
{
    #ifdef DEBUG
    if(dest == NULL)
    {
        fprintf(stderr,"dest is NULL\n");
        abort();
    }
    if(src == NULL)
    {
        fprintf(stderr,"src is NULL\n");
        abort();
    }
    #endif
    char *tmp_dest = (char *)dest;
    char *tmp_src = (char *)src;
    while(len --)
        *tmp_dest ++ = *tmp_src ++;
    return dest;
}

int main(int argc, char** argv)
{
    int *dest = NULL;
    int *src = (int *)malloc(N * sizeof(int));
    dest = mem_cpy(dest, src, N);

    return 0;
}
```

### C
```c
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#define N 10

void *mem_cpy(void *dest, const void *src, size_t len)
{
    assert(dest != NULL && src !=NULL);
    char *tmp_dest = (char *)dest;
    char *tmp_src = (char *)src;
    while(len --)
            *tmp_dest ++ = *tmp_src ++;
    return dest;
}

int main(int argc, char** argv)
{
    int *dest = NULL;
    int *src = (int *)malloc(N * sizeof(int));
    dest = mem_cpy(dest, src, N);

    return 0;
}
```
