# 数组元素排序

利用rand()函数随机生成100以内的正整数，用于填充整数数组，并使用qsort()函数实现数组元素的升序排序。请选出<span style="color:red">正确</span>答案。

## 答案
```c
#include <stdio.h>
#include <stdlib.h>
#define ARR_LEN 10

void fill_array(int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        array[i] = rand() % 100;
}

int compare(const void *p_1, const void *p_2)
{
    const int *a_1 = (const int *)p_1;
    const int *a_2 = (const int *)p_2;
    return *a_1 > *a_2 ? 1 : (*a_1 == *a_2 ? 0: -1);
}

void print_array(const int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

int main(int argc, char** argv)
{
    int array[ARR_LEN];
    fill_array(array, ARR_LEN);
    printf("排序前：\n");
    print_array(array, ARR_LEN);
    qsort(array, ARR_LEN, sizeof(int), compare);
    printf("排序前：\n");
    print_array(array, ARR_LEN);

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>
#include <stdlib.h>
#define ARR_LEN 10

void fill_array(int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        array[i] = rand() % 100;
}

int compare(const int *a_1, const int *a_2)
{
    return *a_1 > *a_2 ? 1 : (*a_1 == *a_2 ? 0: -1);
}

void print_array(const int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

int main(int argc, char** argv)
{
    int array[ARR_LEN];
    fill_array(array, ARR_LEN);
    printf("排序前：\n");
    print_array(array, ARR_LEN);
    qsort(array, ARR_LEN, sizeof(int), compare);
    printf("排序前：\n");
    print_array(array, ARR_LEN);

    return 0;
}

```

### B
```c
#include <stdio.h>
#include <stdlib.h>
#define ARR_LEN 10

void fill_array(int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        array[i] = rand() % 100;
}

int compare(const void *p_1, const void *p_2)
{
    const int *a_1 = (const int *)p_1;
    const int *a_2 = (const int *)p_2;
    return *a_1 < *a_2 ? 1 : (*a_1 == *a_2 ? 0: -1);
}

void print_array(const int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

int main(int argc, char** argv)
{
    int array[ARR_LEN];
    fill_array(array, ARR_LEN);
    printf("排序前：\n");
    print_array(array, ARR_LEN);
    qsort(array, ARR_LEN, sizeof(int), compare);
    printf("排序前：\n");
    print_array(array, ARR_LEN);

    return 0;
}
```

### C
```c
#include <stdio.h>
#include <stdlib.h>
#define ARR_LEN 10

void fill_array(int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        array[i] = rand();
}

int compare(const void *p_1, const void *p_2)
{
    const int *a_1 = (const int *)p_1;
    const int *a_2 = (const int *)p_2;
    return *a_1 < *a_2 ? 1 : (*a_1 == *a_2 ? 0: -1);
}

void print_array(const int array[], const int len)
{
    int i;
    for (i = 0; i < len; ++i)
        printf("%d ", array[i]);
    printf("\n");
}

int main(int argc, char** argv)
{
    int array[ARR_LEN];
    fill_array(array, ARR_LEN);
    printf("排序前：\n");
    print_array(array, ARR_LEN);
    qsort(array, ARR_LEN, sizeof(int), compare);
    printf("排序前：\n");
    print_array(array, ARR_LEN);

    return 0;
}
```
