#include <stdio.h>
#include <stdlib.h>

#define N 5

int *readline(int *mem_size)
{
    int *array = NULL;
    int size = N;
    array = (int *)malloc((size + 1) * sizeof(int));
    if (array == NULL)
    {
        printf("内存分配失败！\n");
        exit(-1);
    }

    int value;
    int count = 0;
    printf("请输入一串整数(以空格隔开)\n(Win按Ctrl+Z结束)\n(Mac先按回车，再按Ctrl+D结束)：\n");
    while (scanf("%d", &value) != EOF)
    {
        ++count;
        if (count > size)
        {
            size += N;
            array = realloc(array, (size + 1) * sizeof(int));
            if (array == NULL)
            {
                printf("重新分配内存空间失败！\n");
                exit(-1);
            }
        }

        array[count] = value;
    }
    array[0] = count;
    *mem_size = size;
    return array;
}

int main(int argc, char** argv)
{
    int i, mem_size, count;
    int *array = readline(&mem_size);
    count = array[0];
    printf("------------------------------\n");
    printf("内存空间大小为：%d\n实际使用量为：%d\n", mem_size, count + 1);
    printf("实际存储数据为：");
    for (i = 1; i <= count; ++i)
        printf("%d ", array[i]);
    free(array);

    return 0;
}