# 使用宏定义函数(2)

定义一个拼接符号的宏，例如
* 使用 `CONCAT(1,000)` 拼接获得`1000`
* 使用 `CONCAT(1,00)` 拼接获得`100`

下面代码正确的选项是？

## 答案

```c

#include <stdio.h>

#define CONCAT(x,y) x##y

int main(int argc, char** args){
    printf("%d", CONCAT(1,000));
    return 0;
}
```

## 选项

### 一个井号

```c
#include <stdio.h>

#define CONCAT(x,y) x#y

int main(int argc, char** args){
    printf("%d", CONCAT(1,000));
    return 0;
}
```

### 加法

```c
#include <stdio.h>

#define CONCAT(x,y) x+y

int main(int argc, char** args){
    printf("%d", CONCAT("1","000"));
    return 0;
}
```

### 凑巧

```c
#include <stdio.h>

#define CONCAT(x,y) x*1000+y

int main(int argc, char** args){
    printf("%d", CONCAT(1,000));
    return 0;
}
```