# 邮费价格表

打印邮费价格表，输出20kg以内物品的邮费价格表，邮费计算规则如下所示：
<div style="text-indent:2em;">* 1kg以内6元。</div>
<div style="text-indent:2em;">* 超过1kg，每增加1kg加收2元。</div><br/>

请选出<span style="color:red">正确</span>的for循环头部，实现上述功能。<br/><br/>

```c
#include <stdio.h>
#define FIRST_COST 6
#define NEXT_COST 2

int main(int argc, char** argv)
{
    int weight, cost;

    printf("重量\t价格\n");
    for (_____(1)_____)
        printf("%d\t¥%d\n", weight, cost);

    return 0;
}
```

<font size="2">
逗号运算符与表达式小知识：
<div style="text-indent:2em;">1. 逗号运算符的优先级是所有运算符中最低的。</div>
<div style="text-indent:2em;">2. 整个逗号表达式的值为其中最后一个子表达式的值。</div>
<div style="text-indent:2em;">3. 逗号运算符常用在for循环头部初始化或递增多个变量</div>
<div style="text-indent:2em;"></div>
</font>
<br/>

## template

```c
#include <stdio.h>
#define FIRST_COST 6
#define NEXT_COST 2

int main(int argc, char** argv)
{
    int weight, cost;

    printf("重量\t价格\n");
    for ($code)
        printf("%d\t¥%d\n", weight, cost);

    return 0;
}
```

## 答案
```c
weight = 1, cost = FIRST_COST; weight <= 10; ++weight, cost = FIRST_COST + (weight - 1) * NEXT_COST
```

## 选项

### A

```c
weight = 1, cost = FIRST_COST; weight <= 10; cost = FIRST_COST + (weight - 1) * NEXT_COST, ++weight
```

### B

```c
weight = 1, cost = FIRST_COST; weight <= 10; cost = (FIRST_COST + (weight - 1) * NEXT_COST, ++weight)
```

### C

```c
weight, cost = 1, FIRST_COST; weight <= 10; ++weight, cost = FIRST_COST + (weight - 1) * NEXT_COST
```


