# 区间是否重叠

输入两个闭区间，并判断两个区间是否重叠。请从下列选项中选出<span style="color:red">错误</span>的判断条件。<br/><br/>

```c
#include <stdio.h>

#define MAX(a,b) ((a > b) ? a : b)
#define MIN(a,b) ((a < b) ? a : b)

int main(int argc, char** argv)
{
    int start_1, end_1;
    int start_2, end_2;
    printf("请输入第1个闭区间(逗号分隔)：");
    scanf("%d,%d", &start_1, &end_1);
    printf("请输入第2个闭区间(逗号分隔)：");
    scanf("%d,%d", &start_2, &end_2);

    if (_____(1)_____)
        printf("两个区间不重叠！");
    else
        printf("两个区间重叠！");

    return 0;
}
```

<font size="2">
关系运算符简介：
<div style="text-indent:2em;">假设两个整型数为 operand1 = 11, operand2 = 2</div><br/>
<table border="1">
  <tr bgcolor="lightyellow">
    <th>关系运算符</th>
    <th>说明</th>
    <th>示例</th>
  </tr>
  <tr>
    <td>==</td>
    <td>判断两个操作数是否相等，若相等则值为1，反之值为0</td>
    <td>operand1 == operand2 的值为 0</td>
  </tr>
  <tr>
    <td>!=</td>
    <td>判断两个操作数是否不相等，若不相等则值为1，反之值为0</td>
    <td>operand1 != operand2 的值为 1</td>
  </tr>
  <tr>
    <td>></td>
    <td>判断第1个操作数是否大于第2个操作数，若大于则值为1，反之值为0</td>
    <td>operand1 > operand2 的值为 1</td>
  </tr>
  <tr>
    <td><</td>
    <td>判断第1个操作数是否小于第2个操作数，若小于则值为1，反之值为0</td>
    <td>operand1 < operand2 的值为 0</td>
  </tr>
  <tr>
    <td>>=</td>
    <td>判断第1个操作数是否大于或等于第2个操作数，若大于或等于则值为1，反之值为0</td>
    <td>operand1 >= operand2 的值为 1</td>
  </tr>
  <tr>
    <td><=</td>
    <td>判断第1个操作数是否小于或等于第2个操作数，若小于或等于则值为1，反之值为0</td>
    <td>operand1 <= operand2 的值为 0</td>
  </tr>
</table>
</font>
<br/>

## template

```c
#include <stdio.h>

#define MAX(a,b) ((a > b) ? a : b)
#define MIN(a,b) ((a < b) ? a : b)

int main(int argc, char** argv)
{
    int start_1, end_1;
    int start_2, end_2;
    printf("请输入第1个闭区间(逗号分隔)：");
    scanf("%d,%d", &start_1, &end_1);
    printf("请输入第2个闭区间(逗号分隔)：");
    scanf("%d,%d", &start_2, &end_2);

    if ($code)
        printf("两个区间不重叠！");
    else
        printf("两个区间重叠！");

    return 0;
}
```

## 答案
```c
end_1 > start_2 || start_1 < end_2
```

## 选项

### A

```c
end_1 < start_2 || start_1 > end_2
```

### B

```c
MAX(start_1, start_2) > MIN(end_1, end_2)
```

### C

```c
MIN(end_1, end_2) < MAX(start_1, start_2)
```
