# 打印被10整除的数

打印100以内（包含100）能被10整除的正整数，如何在合适的位置使用自增运算符实现该功能，请选出<span style="color:red">正确</span>答案填在(1)处。<br/><br/>

```c
#include <stdio.h>

#define UPPER 100

int main(int argc, char** argv)
{
    int i = 1;
    _____(1)_____

    return 0;
}
```

<font size="2">
算术运算符简介：
<div style="text-indent:2em;">假设两个整型数为 operand1 = 11, operand2 = 2</div><br/>
<table border="1">
  <tr bgcolor="lightyellow">
    <th>算术运算符</th>
    <th>说明</th>
    <th>示例</th>
  </tr>
  <tr>
    <td>+</td>
    <td>两个操作数相加</td>
    <td>operand1 + operand2 的值为 13</td>
  </tr>
  <tr>
    <td>-</td>
    <td>第1个操作数减去第2个操作数</td>
    <td>operand1 - operand2 的值为 9</td>
  </tr>
  <tr>
    <td>*</td>
    <td>两个操作数相乘</td>
    <td>operand1 * operand2 的值为 22</td>
  </tr>
  <tr>
    <td>/</td>
    <td>第1个操作数除以第2个操作数</td>
    <td>operand1 / operand2 的值为 5</td>
  </tr>
  <tr>
    <td>%</td>
    <td>取模运算符，整除后的余数</td>
    <td>operand1 % operand2 的值为 1</td>
  </tr>
  <tr>
    <td>++</td>
    <td>自增运算符，整型值自增1</td>
    <td>++operand1 或 operand1++ 的值为 12</td>
  </tr>
  <tr>
    <td>--</td>
    <td>自减运算符，整型值自减1</td>
    <td>--operand1 或 operand1-- 的值为 10</td>
  </tr>
</table>
</font>
<br/>

## template

```c
#include <stdio.h>

#define UPPER 100

int main(int argc, char** argv)
{
    int i = 1;
$code

    return 0;
}
```

## 答案

```c
    while (i++ < UPPER)
        if (i % 10 == 0)
            printf("%d\n", i);
```

## 选项

### A

```c
    while (i++ < UPPER)
        if (i / 10 == 0)
            printf("%d\n", i);

```

### B

```c
    while (++i < UPPER)
        if (i % 10 == 0)
            printf("%d\n", i);
```

### C

```c
    while (i < UPPER)
    {
        if (i % 10 == 0)
            printf("%d\n", i);
        i++;
    }
```
