# 打印C语言的特点

使用字符数组在控制台打印C语言的常见特点。请选出<span style="color:red">错误</span>的print函数。<br/><br/>

```c
#include <stdio.h>
#define ROW 7
#define COL 50

int main(int argc, char** argv)
{
    char feature[ROW][COL] = {
        "1. 语言简洁，使用方便灵活",
        "2. 可移植性好",
        "3. 表达能力强",
        "4. 表达方式灵活",
        "5. 可进行结构化程序设计",
        "6. 可以直接操作计算机硬件",
        "7. 生成的目标代码质量高"};

    printf("********** C语言特点 **********\n");
    print(feature);
    printf("*******************************\n");

    return 0;
}
```

<font size="2">
C语言特点：
<div style="text-indent:2em;"><img src="https://img-community.csdnimg.cn/images/4ccf9d0d03ec4cc9bd0dfb64e36ef849.png"  alt="C语言特点" width="390"/></div>
</font>
<br/>

## template

```c
#include <stdio.h>
#define ROW 7
#define COL 50

$code

int main(int argc, char** argv)
{
    char feature[ROW][COL] = {
        "1. 语言简洁，使用方便灵活",
        "2. 可移植性好",
        "3. 表达能力强",
        "4. 表达方式灵活",
        "5. 可进行结构化程序设计",
        "6. 可以直接操作计算机硬件",
        "7. 生成的目标代码质量高"};

    printf("********** C语言特点 **********\n");
    print(feature);
    printf("*******************************\n");

    return 0;
}
```

## 答案
```c
void print(char feature[ROW][COL])
{
    for line in feature:
        printf("%s\n", line);
}
```

## 选项

### 以字符串的粒度进行打印

```c
void print(char feature[ROW][COL])
{
    for (int i = 0; i < ROW; ++i)
        printf("%s\n", feature[i]);
}
```

### 以字符的粒度进行打印

```c
void print(char feature[ROW][COL])
{
    for (int i = 0; i < ROW; ++i)
    {
        for (int j = 0; feature[i][j] != '\0'; ++j)
            printf("%c", feature[i][j]);
        printf("\n");
    }
}
```

### 使用 while 循环进行打印

```c
void print(char feature[ROW][COL])
{
    int i = 0;
    while (i < ROW)
        printf("%s\n", feature[i++]);
}
```


