# -*- coding: UTF-8 -*-
from common.logger import init_log

from config.config import load_config
from options import parse_options, show_help
from tree import gen_tree
from os import walk
import os.path


def test(config, options, actions):
    import test as test
    test.dispatch(config, options, actions)


def readall(path):
    with open(path) as f:
        return f.read()


def write(path, data):
    with open(path, "w") as f:
        f.write(data)


def makeup():
    for dir, sub_dirs, files in walk("../data"):
        for fname in files:
            _, ext = os.path.splitext(fname)
            if ext == ".md":
                full_path = os.path.join(dir, fname)
                content = readall(full_path)
                lines = content.split("\n")
                new_lines = []
                flag = False
                in_block = False
                for line in lines:
                    new_line = line
                    if line.startswith("```"):
                        if in_block:
                            in_block = False
                        else:
                            in_block = True
                            if line[3:] != "":
                                continue
                            else:
                                new_line = line + 'c'
                                flag = True
                                
                    new_lines.append(new_line)

                if flag:
                    content = "\n".join(new_lines)
                    write(full_path, content)


def tree(config, options, actions):
    import test as test
    gen_tree("../data")


def run(options):
    # 操作入口
    if options.action is not None:
        actions = options.action.split('.')
        if len(actions) == 0:
            return

        print('@init config...')
        config = load_config(options, args)
        print('')

        print('@init log...')
        init_log(config, options)
        print('')

        print('@dispatch action:{}...'.format(options.action))
        root_action = actions[0]
        next = actions[1:]
        dispatch = {
            'test': lambda: test(config, options, next),
            'tree': lambda: tree(config, options, next),
            'makeup': lambda: makeup()
        }
        dispatch[root_action]()
    else:
        show_help()


if __name__ == "__main__":
    [options, args] = parse_options()
    run(options)
