# 使用宏定义函数(3)

当一个宏参数被放进宏体时，这个宏参数会首先被全部展开。定义一个宏，用来打印另外一个宏调用展开后的表达式。例如当调用`printf(MACRO_2_STR( ADD( ADD( 1,000 ), 000 ) ));`时，可以输出展开后的表达式`1+000+000`。

下面哪个选项输出`1+000+000`？

## 答案

```c
#include <stdio.h>

#define ADD( x, y )  x+y
#define TO_STR(x) #x
#define MACRO_2_STR( x ) TO_STR( x )

int main(int argc, char** args){
    printf(MACRO_2_STR( ADD( ADD( 1,000 ), 000 ) ));
    return 0;
}
```

## 选项

### 选项1

```c
#include <stdio.h>

#define ADD( x, y )  x+y
#define MACRO_2_STR( x ) #x

int main(int argc, char** args){
    printf(MACRO_2_STR( ADD( ADD( 1,000 ), 000 ) ));
    return 0;
}
```

### 选项2

```c
#include <stdio.h>

#define ADD( x, y )  x+y

int main(int argc, char** args){
    printf("%d",ADD( ADD(1,1000), 000 ) );
    return 0;
}
```

### 选项3

```c
#include <stdio.h>

#define CONCAT( x, y )  x##y

int main(int argc, char** args){
    printf("%d",CONCAT( CONCAT(1, 1000), 000 ) );
    return 0;
}
```
