# 联合体

定义一个师生信息结构体，并实例化一个结构体数组，用于保存师生的基本信息，其中 **un** 字段用于保存学生的成绩或者教师的教学科目，最后输出所有人员信息。请选出正确答案。

## 答案
```c
#include <stdio.h>
#include <string.h>
#define STR_LEN 20

typedef struct
{
    char *name;
    int id;
    unsigned int age;
    char profession[STR_LEN];
    union
    {
        float score;
        char course[STR_LEN];
    }un;
}Person;

int main()
{
    Person persons[] = {
        {.name = "张三", .id = 1001, .age = 16, .profession = "学生", .un.score = 95.50},
        {.name = "李四", .id = 1002, .age = 15, .profession = "学生", .un.score = 90.00},
        {.name = "王五", .id = 2001, .age = 26, .profession = "教师", .un.course = "语文"}
    };

    size_t i, num_per = sizeof(persons) / sizeof(Person);
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号/工号\t年龄\t身份\t成绩/学科\n");
    printf("--------------------------------------------\n");
    for (i = 0; i < num_per; ++i) {
        Person per = persons[i];
        if (strcmp(per.profession, "学生") == 0)
            printf("%s\t%d\t\t%d\t%s\t%.2f\n",
                per.name, per.id, per.age, per.profession, per.un.score);
        else
            printf("%s\t%d\t\t%d\t%s\t%s\n",
                per.name, per.id, per.age, per.profession, per.un.course);
    }
    printf("============================================\n");

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>
#include <string.h>
#define STR_LEN 20

typedef struct
{
    char *name;
    int id;
    unsigned int age;
    char profession[STR_LEN];
    union
    {
        float score;
        char course[STR_LEN];
    }un;
}Person;

int main()
{
    Person persons[] = {
        {.name = "张三", .id = 1001, .age = 16, .profession = "学生", .un.score = 95.50},
        {.name = "李四", .id = 1002, .age = 15, .profession = "学生", .un.score = 90.00},
        {.name = "王五", .id = 2001, .age = 26, .profession = "教师", .un.course = "语文"}
    };

    size_t i, num_per = sizeof(persons) / sizeof(Person);
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号/工号\t年龄\t身份\t成绩/学科\n");
    printf("--------------------------------------------\n");
    for (i = 0; i < num_per; ++i) {
        Person per = persons[i];
        printf("%s\t%d\t\t%d\t%s\t%.2f\n",
            per.name, per.id, per.age, per.profession, per.un.score);
    }
    printf("============================================\n");

    return 0;
}
```

### B
```c
#include <stdio.h>
#include <string.h>
#define STR_LEN 20

typedef struct
{
    char *name;
    int id;
    unsigned int age;
    char profession[STR_LEN];
    union
    {
        float score;
        char course[STR_LEN];
    }un;
}Person;

int main()
{
    Person persons[] = {
        {"张三", 1001, 16, "学生", 95.50},
        {"李四", 1002, 15, "学生", 90.00},
        {"王五", 2001, 26, "教师", "语文"}
    };

    size_t i, num_per = sizeof(persons) / sizeof(Person);
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号/工号\t年龄\t身份\t成绩/学科\n");
    printf("--------------------------------------------\n");
    for (i = 0; i < num_per; ++i) {
        Person per = persons[i];
        if (strcmp(per.profession, "学生") == 0)
            printf("%s\t%d\t\t%d\t%s\t%.2f\n",
                per.name, per.id, per.age, per.profession, per.un.score);
        else
            printf("%s\t%d\t\t%d\t%s\t%s\n",
                per.name, per.id, per.age, per.profession, per.un.course);
    }
    printf("============================================\n");

    return 0;
}
```

### C
```c
#include <stdio.h>
#include <string.h>
#define STR_LEN 20

typedef struct
{
    char *name;
    int id;
    unsigned int age;
    char profession[STR_LEN];
    union un
    {
        float score;
        char course[STR_LEN];
    };
}Person;

int main()
{
    Person persons[] = {
        {.name = "张三", .id = 1001, .age = 16, .profession = "学生", .un.score = 95.50},
        {.name = "李四", .id = 1002, .age = 15, .profession = "学生", .un.score = 90.00},
        {.name = "王五", .id = 2001, .age = 26, .profession = "教师", .un.course = "语文"}
    };

    size_t i, num_per = sizeof(persons) / sizeof(Person);
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号/工号\t年龄\t身份\t成绩/学科\n");
    printf("--------------------------------------------\n");
    for (i = 0; i < num_per; ++i) {
        Person per = persons[i];
        if (strcmp(per.profession, "学生") == 0)
            printf("%s\t%d\t\t%d\t%s\t%.2f\n",
                per.name, per.id, per.age, per.profession, per.un.score);
        else
            printf("%s\t%d\t\t%d\t%s\t%s\n",
                per.name, per.id, per.age, per.profession, per.un.course);
    }
    printf("============================================\n");

    return 0;
}
```
