# 链式结构

定义一个学生结构体，并创建一个链表用于保存一个班级所有学生的基本信息，最后输出所有学生基本信息，以及班级的学生平均成绩。请选出正确答案。

## 答案
```c
#include <stdio.h>
#include <stdlib.h>

typedef struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
    struct Student *next;
} Student, *Class;

Class init_class()
{
    Class head;
    head = (Student *)malloc(sizeof(Student));
    if (!head)
        return NULL;
    head->next = NULL;
    return head;
}

void insert_student(Class cls, char *name, int id, unsigned int age, char group, float score)
{
    Class p;
    p = (Student *)malloc(sizeof(Student));
    p->name = name, p->id = id, p->age = age, p->group = group, p->score = score;
    p->next = cls->next;
    cls->next = p;
}

void print_class(const Class cls)
{
    Class prt = NULL;
    float total = 0, average = 0;
    int num_stu = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (prt = cls->next; prt; prt = prt->next)
    {
        printf("%s\t%d\t%d\t%c\t%.2f\n",
               prt->name, prt->id, prt->age, prt->group, prt->score);
        total += prt->score;
        ++num_stu;
    }
    printf("============================================\n");
    average = total / num_stu;
    printf("班级平均成绩：%.2f", average);
}

int main()
{
    Class cls = init_class();
    insert_student(cls, "王五", 1003, 16, 'B', 80.50);
    insert_student(cls, "李四", 1002, 15, 'A', 90.00);
    insert_student(cls, "张三", 1001, 16, 'A', 95.50);

    print_class(cls);

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>
#include <stdlib.h>

typedef struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
    struct Student *next;
} Student, *Class;

Class init_class()
{
    Class head;
    head = (Student *)malloc(sizeof(Student));
    if (!head)
        return NULL;
    head->next = NULL;
    return head;
}

void insert_student(Class cls, char *name, int id, unsigned int age, char group, float score)
{
    Class p;
    p = (Student *)malloc(sizeof(Student));
    p->name = name, p->id = id, p->age = age, p->group = group, p->score = score;
    p->next = cls->next;
    cls->next = p;
}

void print_class(const Class cls)
{
    Class prt = NULL;
    float total = 0, average = 0;
    int num_stu = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (prt = cls; prt; prt = prt->next)
    {
        printf("%s\t%d\t%d\t%c\t%.2f\n",
               prt->name, prt->id, prt->age, prt->group, prt->score);
        total += prt->score;
        ++num_stu;
    }
    printf("============================================\n");
    average = total / num_stu;
    printf("班级平均成绩：%.2f", average);
}

int main()
{
    Class cls = init_class();
    insert_student(cls, "王五", 1003, 16, 'B', 80.50);
    insert_student(cls, "李四", 1002, 15, 'A', 90.00);
    insert_student(cls, "张三", 1001, 16, 'A', 95.50);

    print_class(cls);

    return 0;
}
```

### B
```c
#include <stdio.h>
#include <stdlib.h>

typedef struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
    struct Student *next;
} Student, *Class;

Class init_class()
{
    Class head;
    head = (Student *)malloc(sizeof(Student));
    if (!head)
        return NULL;
    head->next = NULL;
    return head;
}

void insert_student(Class cls, char *name, int id, unsigned int age, char group, float score)
{
    Class p, q;
    p = (Student *)malloc(sizeof(Student));
    p->name = name, p->id = id, p->age = age, p->group = group, p->score = score;
    cls->next = p;
    p->next = cls->next;
}

void print_class(const Class cls)
{
    Class prt = NULL;
    float total = 0, average = 0;
    int num_stu = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (prt = cls->next; prt; prt = prt->next)
    {
        printf("%s\t%d\t%d\t%c\t%.2f\n",
               prt->name, prt->id, prt->age, prt->group, prt->score);
        total += prt->score;
        ++num_stu;
    }
    printf("============================================\n");
    average = total / num_stu;
    printf("班级平均成绩：%.2f", average);
}

int main()
{
    Class cls = init_class();
    insert_student(cls, "王五", 1003, 16, 'B', 80.50);
    insert_student(cls, "李四", 1002, 15, 'A', 90.00);
    insert_student(cls, "张三", 1001, 16, 'A', 95.50);

    print_class(cls);

    return 0;
}
```

### C
```c
#include <stdio.h>
#include <stdlib.h>

typedef struct Student
{
    char *name;
    int id;
    unsigned int age;
    char group;
    float score;
    struct Student *next;
} Student, *Class;

Class init_class()
{
    Class head;
    head = (Student *)malloc(sizeof(Student));
    if (!head)
        return NULL;
    head->next = NULL;
    return head;
}

void insert_student(Class cls, char *name, int id, unsigned int age, char group, float score)
{
    Class p;
    p = (Student *)malloc(sizeof(Student));
    p->name = name, p->id = id, p->age = age, p->group = group, p->score = score;
    p->next = cls->next;
    cls->next = p;
}

void print_class(const Class cls)
{
    Class prt = NULL;
    float total = 0, average = 0;
    int num_stu = 0;
    printf("=============== 学生基本信息 ===============\n");
    printf("姓名\t学号\t年龄\t小组\t成绩\n");
    printf("--------------------------------------------\n");
    for (prt = (*cls).next; prt; ++prt)
    {
        printf("%s\t%d\t%d\t%c\t%.2f\n",
               prt->name, prt->id, prt->age, prt->group, prt->score);
        total += prt->score;
        ++num_stu;
    }
    printf("============================================\n");
    average = total / num_stu;
    printf("班级平均成绩：%.2f", average);
}

int main()
{
    Class cls = init_class();
    insert_student(cls, "王五", 1003, 16, 'B', 80.50);
    insert_student(cls, "李四", 1002, 15, 'A', 90.00);
    insert_student(cls, "张三", 1001, 16, 'A', 95.50);

    print_class(cls);

    return 0;
}
```
