# 字符串输入与输出

输入一个字符串，并反向输出。请选出错误答案。

## 答案
```c
#include <stdio.h>
#define STR_LEN 101

void reverse(char *str)
{
    char* head = str;    
    char* tail = str;
    char ch;
 
    while(*tail++);
    tail -= 2;
 
    while(head < tail)
    {
        ch = *head;
        *head++ = *tail;
        *tail-- = ch;
    }
}

int main()
{
    char str[STR_LEN];
    char *rev_str = NULL;
    fputc("请输入一个字符串(length<=100)：", stdout);
    fgetc(str);
    reverse(str);
    fputc("反转后的字符串为：", stdout);
    fputc(str, stdout);

    return 0;
}
```

## 选项
### A
```c
#include <stdio.h>
#define STR_LEN 101

void reverse(char *str)
{
    char* head = str;    
    char* tail = str;
    char ch;
 
    while(*tail++);
    tail -= 2;
 
    while(head < tail)
    {
        ch = *head;
        *head++ = *tail;
        *tail-- = ch;
    }
}

int main()
{
    char str[STR_LEN];
    char *rev_str = NULL;
    puts("请输入一个字符串(length<=100)：");
    gets(str);
    reverse(str);
    puts("反转后的字符串为：");
    puts(str);

    return 0;
}
```

### B
```c
#include <stdio.h>
#define STR_LEN 101

void reverse(char *str)
{
    char* head = str;    
    char* tail = str;
    char ch;
 
    while(*tail++);
    tail -= 2;
 
    while(head < tail)
    {
        ch = *head;
        *head++ = *tail;
        *tail-- = ch;
    }
}

int main()
{
    char str[STR_LEN];
    char *rev_str = NULL;
    printf("请输入一个字符串(length<=100)：\n");
    scanf("%s", str);
    reverse(str);
    printf("反转后的字符串为：\n%s", str);

    return 0;
}
```

### C
```c
#include <stdio.h>
#define STR_LEN 101

void reverse(char *str)
{
    char* head = str;    
    char* tail = str;
    char ch;
 
    while(*tail++);
    tail -= 2;
 
    while(head < tail)
    {
        ch = *head;
        *head++ = *tail;
        *tail-- = ch;
    }
}

int main()
{
    char str[STR_LEN];
    char *rev_str = NULL;
    fputs("请输入一个字符串(length<=100)：\n", stdout);
    fgets(str, STR_LEN, stdin);
    reverse(str);
    fputs("反转后的字符串为：", stdout);
    fputs(str, stdout);

    return 0;
}
```
