# 函数指针

使用函数指针调用自定义函数。请选出错误答案。

## 答案

```c
#include <stdio.h>

int max(int a, int b)
{
    return a > b ? a : b;
}

int main()
{
    int x, y, max_val;
    int *p_max(int, int) = max;

    printf("请输入两个整数：");
    scanf("%d,%d", &x, &y);

    max_val = *p_max(x, y);
    printf("两数中最大值为：%d\n", max_val);

    return 0;
}
```

## 选项

### A

```c
#include <stdio.h>

int max(int a, int b)
{
    return a > b ? a : b;
}

int main()
{
    int x, y, max_val;
    int (*p_max)(int, int) = &max;

    printf("请输入两个整数：");
    scanf("%d,%d", &x, &y);

    max_val = p_max(x, y);
    printf("两数中最大值为：%d\n", max_val);

    return 0;
}
```

### B

```c
#include <stdio.h>

int max(int a, int b)
{
    return a > b ? a : b;
}

int main()
{
    int x, y, max_val;
    int (*p_max)(int, int) = max;

    printf("请输入两个整数：");
    scanf("%d,%d", &x, &y);

    max_val = (*p_max)(x, y);
    printf("两数中最大值为：%d\n", max_val);

    return 0;
}
```

### C

```c
#include <stdio.h>

int max(int a, int b)
{
    return a > b ? a : b;
}

int main()
{
    int x, y, max_val;
    int (*p_max)(int a, int b) = max;

    printf("请输入两个整数：");
    scanf("%d,%d", &x, &y);

    max_val = (*p_max)(x, y);
    printf("两数中最大值为：%d\n", max_val);

    return 0;
}
```

