# 邮费价格表

打印邮费价格表，输出20kg以内物品的邮费价格表，邮费计算规则如下所示：
* 1kg以内6元。
* 超过1kg，每增加1kg加收2元。

请选出正确答案。

## 答案
```c
#include <stdio.h>
#define FIRST_COST 6
#define NEXT_COST 2

int main()
{
    int weight, cost;

    printf("重量\t价格\n");
    for (weight = 1, cost = FIRST_COST; 
         weight <= 10; 
         ++weight, cost = FIRST_COST + (weight - 1) * NEXT_COST)
        printf("%d\t¥%d\n", weight, cost);

    return 0;
}
```

## 选项

### A

```c
#include <stdio.h>
#define FIRST_COST 6
#define NEXT_COST 2

int main()
{
    int weight, cost;

    printf("重量\t价格\n");
    for (weight = 1, cost = FIRST_COST; 
         weight <= 10; 
         cost = FIRST_COST + (weight - 1) * NEXT_COST, ++weight)
        printf("%d\t¥%d\n", weight, cost);

    return 0;
}
```

### B

```c
#include <stdio.h>
#define FIRST_COST 6
#define NEXT_COST 2

int main()
{
    int weight, cost;

    printf("重量\t价格\n");
    for (weight = 1, cost = FIRST_COST; 
         weight <= 10; 
         cost = (FIRST_COST + (weight - 1) * NEXT_COST, ++weight))
        printf("%d\t¥%d\n", weight, cost);

    return 0;
}
```

### C

```c
#include <stdio.h>
#define FIRST_COST 6
#define NEXT_COST 2

int main()
{
    int weight, cost;

    printf("重量\t价格\n");
    for (weight, cost = 1, FIRST_COST; 
         weight <= 10; 
         ++weight, cost = FIRST_COST + (weight - 1) * NEXT_COST)
        printf("%d\t¥%d\n", weight, cost);

    return 0;
}
```


