# 使用宏定义函数(1)

定义一个宏函数，将符号转成字符串，下面代码正确的选项是？

## 答案

```c
#include <stdio.h>

#define TO_STR(s) #s

int main(int argc, char** args){
    printf(TO_STR(1000));
    printf(TO_STR(HelloWorld!));
    return 0;
}
```

## 选项

### 错误实现

```c
#include <stdio.h>

#define TO_STR(s) "s"

int main(int argc, char** args){
    printf(TO_STR(1000));
    printf(TO_STR(HelloWorld!));
    return 0;
}
```

### 错误调用

```c
#include <stdio.h>

#define TO_STR(s) #s

int main(int argc, char** args){
    printf(TO_STR(1000));
    printf(TO_STR(Hello,World!));
    return 0;
}
```

### 凑巧

```c
#include <stdio.h>

#define TO_STR(s) ##s

int main(int argc, char** args){
    printf(TO_STR(1000));
    printf(TO_STR(HelloWorld!));
    return 0;
}
```