# 数组下标

求整形数组中的最大值，并输出其对应的下标。(1)处为找最大值的核心代码，请判断四个选项中哪一项<span style="color:red">无法</span>实现该功能。

```c
#include <stdio.h>
#define LEN 10

int main(int argc, char **argv)
{
    int arr[LEN] = {2, 5, 1, 10, 4, 8, 6, 3, 9, 7};
    int i, j, max_value, position;

    _____(1)_____;

    printf("数组中的最大值为：%d\n", max_value);
    printf("最大值在数组中的下标为：%d\n", position);

    return 0;
}
```

<font size="2">
小知识：为什么数组下标要从0开始编号？
<div style="text-indent:2em;">为什么数组下标要从0开始编号，而不是从1开始呢？从1开始不是更符合人类的思维习惯吗？</div>
<div style="text-indent:2em;">从数组存储的内存模型上来看，下标实际上指的是偏移量(offset)。例如：一个整型数组 int arr[LEN]，</div>
<div style="text-indent:4em;">* 从0开始编号，元素arr[i]的寻址计算公式是：address(arr[i]) = address(arr) + i * sizeof(int)。</div>
<div style="text-indent:4em;">* 从1开始编号，元素arr[i]的寻址计算公式是：address(arr[i]) = address(arr) + (i - 1) * sizeof(int)。</div>
<div style="text-indent:2em;">对比两个公式，从1开始编号会多一次减法运算，对应到CPU就会多一条减法指令。而数组取下标是一个高频操作，故从0开始效率更高。另外，C语言的设计者从0开始编号数组元素，之后的C++、Java、Python等高级语言也沿用了C的编号习惯，这也在一定程度上降低了C语言程序员学习其他编程语言的成本。当然，并不是所有语言的数组都是从0开始编号，比如MATLAB。</div>
</font>
<br/>


## template

```c
#include <stdio.h>
#define LEN 10

int main(int argc, char **argv)
{
    int arr[LEN] = {2, 5, 1, 10, 4, 8, 6, 3, 9, 7};
    int i, j, max_value, position;

    max_value = arr[0];
    for (i = 1; i < LEN; ++i)
        if (max_value < arr[i])
        {
            max_value = arr[i];
            position = i;
        }

    printf("数组中的最大值为：%d\n", max_value);
    printf("最大值在数组中的下标为：%d\n", position);

    return 0;
}
```

## 答案

```c
    max_value = arr[1];
    for (i = 2; i <= LEN; ++i)
        if (max_value < arr[i])
        {
            max_value = arr[i];
            position = i;
        }
```

## 选项

### A
```c
    max_value = arr[0];
    for (i = 1; i < LEN; ++i)
        if (max_value < arr[i])
        {
            max_value = arr[i];
            position = i;
        }
```

### B

```c
    max_value = arr[0];
    for (i = LEN - 1; i > 0; --i)
        if (max_value < arr[i])
        {
            max_value = arr[i];
            position = i;
        }
```

### C

```c
    max_value = arr[LEN - 1];
    for (i = 0; i < LEN - 1; ++i)
        if (max_value < arr[i])
        {
            max_value = arr[i];
            position = i;
        }
```

