# 打印技能树名称和网址

自定义一个输出函数，打印C语言技能树的名称和网址。以下关于函数的声明和定义，请判断哪一项是<span style="color:red">错误</span>的。

```c
#include <stdio.h>

_____(1)_____;

int main(int argc, char** argv)
{
    char tree_name[] = "C语言";
    char tree_link[] = "https://clang.csdn.net";
    print_skill_tree(tree_name, tree_link);
    return 0;
}

_____(2)_____
```

<font size="2">
小知识：C语言函数声明和定义语法：

```c
// 函数原型(可作为函数声明)
return_type function_name(parameter_types); 

// main函数代码

// 函数定义
return_type function_name (function_parameters) { 
    // 函数被调用时需要执行的语句或程序块
    return value;
}
```

</font>
<br/>

## template

```c
#include <stdio.h>

void print_skill_tree(char tree_name[], char link[]);

int main(int argc, char** argv)
{
    char tree_name[] = "C语言";
    char tree_link[] = "https://clang.csdn.net";
    print_skill_tree(tree_name, tree_link);
    return 0;
}

void print_skill_tree(char tree_name[], char link[])
{
    printf("欢迎访问\"%s技能树\"网址：%s", tree_name, link);
}
```

## 答案
```c
(1) 
不填

(2) 
void print_skill_tree(char tree_name[], char link[])
{
    printf("欢迎访问\"%s技能树\"网址：%s", tree_name, link);
}
```


## 选项
### A
```c
(1) 
void print_skill_tree(char tree_name[], char link[]);

(2) 
void print_skill_tree(char tree_name[], char link[])
{
    printf("欢迎访问\"%s技能树\"网址：%s", tree_name, link);
}
```

### B
```c
(1) 
void print_skill_tree(char [], char []);

(2) 
void print_skill_tree(char tree_name[], char link[])
{
    printf("欢迎访问\"%s技能树\"网址：%s", tree_name, link);
}
```

### C
```c
(1) 
void print_skill_tree(char tree_name[], char link[])
{
    printf("欢迎访问\"%s技能树\"网址：%s", tree_name, link);
}

(2) 
不填
```
