# for循环：九九乘法表

使用for循环，打印九九乘法表。下列四个选项中有一项无法实现该功能，请找出该<span style="color:red">错误</span>选项。

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    int i = 0;
    int j = 0;

    _____(1)_____;

    return 0;
}
```

<font size="2">
C语言for循环流程图：
<div style="text-indent:2em;"><img src="https://img-community.csdnimg.cn/images/ecbf67a5a346417086ebeecb4b8efe8e.png"  alt="C语言for循环" width="390"/></div>
</font>
<br/>

## template

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    int i = 0;
    int j = 0;

$code

    return 0;
}
```

## 答案

```c
    for(i = 1, j = 1; i * j <= 81; ++i, ++j) {
        printf("%d*%d=%2d\t", i, j, i * j);
        if ((i * j) % 9 == 0)
            printf("\n");
    }
```

## 选项

### 使用两层循环
```c
    for(i = 1; i <= 9; ++i) 
    {
        for(j = 1; j <= 9; ++j)
            printf("%d*%d=%2d\t", i, j, i * j);
        printf("\n");
    }
```

### 使用一层循环

```c
    int row = 0;
    int col = 0;
    for(i = 0; i < 81; ++i) 
    {
        row = i / 9 + 1;
        col = i % 9 + 1;
        printf("%d*%d=%2d\t", row, col, row * col);
        if ((i + 1) % 9 == 0)
            printf("\n");
    }
```

### 使用break

```c
    i = 1;
    for(; ; ) {
        if (i > 9)
            break;
        j = 1;
        for(; ; )
        {
            if (j > 9)
                break;
            printf("%d*%d=%2d\t", i, j, i * j);
            ++j;
        }
        printf("\n");
        ++i;
    }
```

