# 运算符优先级与求值顺序

选项中是关于逗号运算符与自增运算符组成的混合表达式，请运用运算符优先级及求值顺序相关知识，选择合适的选项填在(1)处，使得程序的输出结果为 <font color=red>**2,3,1**</font>。<br/><br/>

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    int x, y, z;
    x = y = 1;
    _____(1)_____;
    printf("%d,%d,%d\n", x, y, z);
}
```

<font size="2">
小知识：C语言运算符优先级与结合性<br/>
<div style="text-indent:2em;">表格从上到下，优先级逐步递减。</div><br/>
<table border="1">
  <tr bgcolor="lightyellow">
    <th>类别</th>
    <th>运算符</th>
    <th>结合性</th>
  </tr>
  <tr>
    <td>后缀运算符(Postfix)</td>
    <td>() [] -> . ++ - -</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>一目运算符(Unary)</td>
    <td>+ - ! ~ ++ - - (type)* & sizeof</td>
    <td>从右到左</td>
  </tr>
  <tr>
    <td>乘性运算符(Multiplicative)</td>
    <td>* / %</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>加性运算符(Additive)</td>
    <td>+ -</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>移位运算符(Shift)</td>
    <td><< >></td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>关系运算符(Relational)</td>
    <td>< <= > >=</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>等性运算符(Equality)</td>
    <td>== !=</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>位与运算符(Bitwise AND)</td>
    <td>&</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>位异或运算符(Bitwise XOR)</td>
    <td>^</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>位或运算符(Bitwise OR)</td>
    <td>|</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>逻辑与运算符(Logical AND)</td>
    <td>&&</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>逻辑或运算符(Logical OR)</td>
    <td>||</td>
    <td>从左到右</td>
  </tr>
  <tr>
    <td>条件运算符(Conditional)</td>
    <td>?:</td>
    <td>从右到左</td>
  </tr>
  <tr>
    <td>赋值运算符(Assignment)</td>
    <td>= += -= *= /= %=>>= <<= &= ^= |=</td>
    <td>从右到左</td>
  </tr>
  <tr>
    <td>逗号运算符(Comma)</td>
    <td>,</td>
    <td>从左到右</td>
  </tr>
</table>
</font>
<br/>

## template

```c
#include <stdio.h>

int main(int argc, char** argv)
{
    int x, y, z;
    x = y = 1;
$code
    printf("%d,%d,%d\n", x, y, z);
}
```

## 答案

```c
    z = x++, ++y, y++;
```

## 选项

### A

```c
    z = (x++, ++y, y++);
```

### B

```c
    z = (x++, ++y), y++;
```

### C
```c
    (z = (x++, ++y)), y++;
```
