# 交换变量值2

使用指针与函数交换两个变量的值。请选出错误答案。

## 答案

```
#include <stdio.h>

void swap(int x, int y)
{
    int temp = x;
    x = y;
    y = temp;
}

int main()
{
    int x, y;
    x = 2, y = 8;

    printf("交换前：x = %d, y = %d\n", x, y);
    swap(x, y);
    printf("交换后：x = %d, y = %d\n", x, y);

    return 0;
}
```

## 选项

### A

```
#include <stdio.h>

void swap(int* x, int* y)
{
    int temp = *x;
    *x = *y;
    *y = temp;
}

int main()
{
    int x, y;
    int* pt_x;
    int* pt_y;

    x = 2, y = 8;
    pt_x = &x;
    pt_y = &y;

    printf("交换前：x = %d, y = %d\n", x, y);
    swap(pt_x, pt_y);
    printf("交换后：x = %d, y = %d\n", x, y);

    return 0;
}
```

### B

```
#include <stdio.h>

void swap(int* x, int* y)
{
    int temp = *x;
    *x = *y;
    *y = temp;
}

int main()
{
    int x, y;
    x = 2, y = 8;

    printf("交换前：x = %d, y = %d\n", x, y);
    swap(&x, &y);
    printf("交换后：x = %d, y = %d\n", x, y);

    return 0;
}
```

### C

```
#include <stdio.h>

void swap(int** x, int** y)
{
    int temp = **x;
    **x = **y;
    **y = temp;
}

int main()
{
    int x, y;
    int* pt_x;
    int* pt_y;

    x = 2, y = 8;
    pt_x = &x;
    pt_y = &y;

    printf("交换前：x = %d, y = %d\n", x, y);
    swap(&pt_x, &pt_y);
    printf("交换后：x = %d, y = %d\n", x, y);

    return 0;
}
```
