# 整数转罗马数字

<div class="notranslate">
    <p>罗马数字包含以下七种字符：&nbsp;<code>I</code>，&nbsp;<code>V</code>，&nbsp;<code>X</code>，&nbsp;<code>L</code>，<code>C</code>，<code>D</code>&nbsp;和&nbsp;<code>M</code>。
    </p>

    <pre><strong>字符</strong>          <strong>数值</strong>
I             1
V             5
X             10
L             50
C             100
D             500
M             1000</pre>

    <p>例如， 罗马数字 2 写做&nbsp;<code>II</code>&nbsp;，即为两个并列的 1。12
        写做&nbsp;<code>XII</code>&nbsp;，即为&nbsp;<code>X</code>&nbsp;+&nbsp;<code>II</code>&nbsp;。 27
        写做&nbsp;&nbsp;<code>XXVII</code>,
        即为&nbsp;<code>XX</code>&nbsp;+&nbsp;<code>V</code>&nbsp;+&nbsp;<code>II</code>&nbsp;。</p>

    <p>通常情况下，罗马数字中小的数字在大的数字的右边。但也存在特例，例如 4 不写做&nbsp;<code>IIII</code>，而是&nbsp;<code>IV</code>。数字 1 在数字 5 的左边，所表示的数等于大数 5
        减小数 1 得到的数值 4 。同样地，数字 9 表示为&nbsp;<code>IX</code>。这个特殊的规则只适用于以下六种情况：</p>

    <ul>
        <li><code>I</code>&nbsp;可以放在&nbsp;<code>V</code>&nbsp;(5) 和&nbsp;<code>X</code>&nbsp;(10) 的左边，来表示 4 和 9。</li>
        <li><code>X</code>&nbsp;可以放在&nbsp;<code>L</code>&nbsp;(50) 和&nbsp;<code>C</code>&nbsp;(100) 的左边，来表示 40
            和&nbsp;90。&nbsp;</li>
        <li><code>C</code>&nbsp;可以放在&nbsp;<code>D</code>&nbsp;(500) 和&nbsp;<code>M</code>&nbsp;(1000) 的左边，来表示&nbsp;400
            和&nbsp;900。</li>
    </ul>

    <p>给你一个整数，将其转为罗马数字。</p>

    <p>&nbsp;</p>

    <p><strong>示例&nbsp;1:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 3
<strong><br />输出:</strong> "III"</pre>

    <p><strong>示例&nbsp;2:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 4
<strong><br />输出:</strong> "IV"</pre>

    <p><strong>示例&nbsp;3:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 9
<strong><br />输出:</strong> "IX"</pre>

    <p><strong>示例&nbsp;4:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 58
<strong><br />输出:</strong> "LVIII"
<strong><br />解释:</strong> L = 50, V = 5, III = 3.
    </pre>

    <p><strong>示例&nbsp;5:</strong></p>

    <pre><strong>输入:</strong>&nbsp;num = 1994
<strong><br />输出:</strong> "MCMXCIV"
<strong><br />解释:</strong> M = 1000, CM = 900, XC = 90, IV = 4.</pre>

    <p>&nbsp;</p>

    <p><strong>提示：</strong></p>

    <ul>
        <li><code>1 &lt;= num &lt;= 3999</code></li>
    </ul>
</div>
<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c
int main()
{
    Solution sol;
    cout << sol.intToRoman(1994) << endl;
    return 0;
}

```

## 答案

```c
class Solution
{
public:
    string intToRoman(int num)
    {
        int nums[13] = {1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        string romans[13] = {"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        string ans;
        int index = 0;
        while (index < 13)
        {
            while (num >= nums[index])
            {
                num = nums[index];
                ans = romans[index];
            }
            index++;
        }
        return ans;
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    string getNum1000(int num1000)
    {
        if (num1000 == 3)
        {
            return "MMM";
        }
        else if (num1000 == 2)
        {
            return "MM";
        }
        else if (num1000 == 1)
        {
            return "M";
        }
        else
        {
            return "";
        }
    }

    string getNum100(int num100)
    {

        switch (num100)
        {
        case 1:
            return "C";
        case 2:
            return "CC";
        case 3:
            return "CCC";
        case 4:
            return "CD";
        case 5:
            return "D";
        case 6:
            return "DC";
        case 7:
            return "DCC";
        case 8:
            return "DCCC";
        case 9:
            return "CM";
        default:
            return "";
        }
    }

    string getNum10(int num10)
    {

        switch (num10)
        {
        case 1:
            return "X";
        case 2:
            return "XX";
        case 3:
            return "XXX";
        case 4:
            return "XL";
        case 5:
            return "L";
        case 6:
            return "LX";
        case 7:
            return "LXX";
        case 8:
            return "LXXX";
        case 9:
            return "XC";
        default:
            return "";
        }
    }

    string getNum1(int num1)
    {
        switch (num1)
        {
        case 1:
            return "I";
        case 2:
            return "II";
        case 3:
            return "III";
        case 4:
            return "IV";
        case 5:
            return "V";
        case 6:
            return "VI";
        case 7:
            return "VII";
        case 8:
            return "VIII";
        case 9:
            return "IX";
        default:
            return "";
        }
    }

    string intToRoman(int num)
    {
        int num1000 = num / 1000;
        int num100 = (num % 1000) / 100;
        int num10 = (num % 100) / 10;
        int num1 = (num % 10);
        string res;
        res = getNum1000(num1000) + getNum100(num100) + getNum10(num10) + getNum1(num1);
        return res;
    }
};
```

### B

```c
class Solution
{
public:
    string intToRoman(int num)
    {
        int values[13] = {1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        string reps[13] = {"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        string res;
        for (int i = 0; i < 13; i++)
        {
            while (num >= values[i])
            {
                num -= values[i];
                res += reps[i];
            }
        }
        return res;
    }
};
```

### C

```c
class Solution
{
public:
    string intToRoman(int num)
    {
        string bit1[10] = {"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        string bit10[10] = {"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        string bit100[10] = {"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
        string bit1000[4] = {"", "M", "MM", "MMM"};
        return bit1000[num / 1000] + bit100[num % 1000 / 100] + bit10[num % 100 / 10] + bit1[num % 10];
    }
};
```
