# 逆波兰表达式求值

<p>根据<a href="https://baike.baidu.com/item/%E9%80%86%E6%B3%A2%E5%85%B0%E5%BC%8F/128437" target="_blank"> 逆波兰表示法</a>，求表达式的值。</p>

<p>有效的算符包括 <code>+</code>、<code>-</code>、<code>*</code>、<code>/</code> 。每个运算对象可以是整数，也可以是另一个逆波兰表达式。</p>

<p> </p>

<p><strong>说明：</strong></p>

<ul>
	<li>整数除法只保留整数部分。</li>
	<li>给定逆波兰表达式总是有效的。换句话说，表达式总会得出有效数值且不存在除数为 0 的情况。</li>
</ul>

<p> </p>

<p><strong>示例 1：</strong></p>

<pre>
<strong>输入：</strong>tokens = ["2","1","+","3","*"]
<strong>输出：</strong>9
<strong>解释：</strong>该算式转化为常见的中缀算术表达式为：((2 + 1) * 3) = 9
</pre>

<p><strong>示例 2：</strong></p>

<pre>
<strong>输入：</strong>tokens = ["4","13","5","/","+"]
<strong>输出：</strong>6
<strong>解释：</strong>该算式转化为常见的中缀算术表达式为：(4 + (13 / 5)) = 6
</pre>

<p><strong>示例 3：</strong></p>

<pre>
<strong>输入：</strong>tokens = ["10","6","9","3","+","-11","*","/","*","17","+","5","+"]
<strong>输出：</strong>22
<strong>解释：</strong>
该算式转化为常见的中缀算术表达式为：
  ((10 * (6 / ((9 + 3) * -11))) + 17) + 5
= ((10 * (6 / (12 * -11))) + 17) + 5
= ((10 * (6 / -132)) + 17) + 5
= ((10 * 0) + 17) + 5
= (0 + 17) + 5
= 17 + 5
= 22</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>1 <= tokens.length <= 10<sup>4</sup></code></li>
	<li><code>tokens[i]</code> 要么是一个算符（<code>"+"</code>、<code>"-"</code>、<code>"*"</code> 或 <code>"/"</code>），要么是一个在范围 <code>[-200, 200]</code> 内的整数</li>
</ul>

<p> </p>

<p><strong>逆波兰表达式：</strong></p>

<p>逆波兰表达式是一种后缀表达式，所谓后缀就是指算符写在后面。</p>

<ul>
	<li>平常使用的算式则是一种中缀表达式，如 <code>( 1 + 2 ) * ( 3 + 4 )</code> 。</li>
	<li>该算式的逆波兰表达式写法为 <code>( ( 1 2 + ) ( 3 4 + ) * )</code> 。</li>
</ul>

<p>逆波兰表达式主要有以下两个优点：</p>

<ul>
	<li>去掉括号后表达式无歧义，上式即便写成 <code>1 2 + 3 4 + * </code>也可以依据次序计算出正确结果。</li>
	<li>适合用栈操作运算：遇到数字则入栈；遇到算符则取出栈顶两个数字进行计算，并将结果压入栈中。</li>
</ul>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
class Solution
{
public:
    int evalRPN(vector<string> &tokens)
    {
        stack<int> stk;
        int n = tokens.size();
        for (int i = 0; i < n; i++)
        {
            string token = tokens[i];
            if (isNumber(token))
            {
                stk.push(atoi(token.c_str()));
            }
            else
            {
                int num2 = stk.top();
                int num1 = stk.top();
                switch (token[0])
                {
                case '+':
                    stk.push(num1 + num2);
                    break;
                case '-':
                    stk.push(num1 - num2);
                    break;
                case '*':
                    stk.push(num1 * num2);
                    break;
                case '/':
                    stk.push(num1 / num2);
                    break;
                }
            }
        }
        return stk.top();
    }

    bool isNumber(string token)
    {
        return !(token == "+" || token == "-" || token == "*" || token == "/");
    }
};
```
## 选项


### A

```c
class Solution
{
public:
    int isNumber(string s)
    {
        return !(s == "+" || s == "-" || s == "*" || s == "/");
    }
    int evalRPN(vector<string> &tokens)
    {
        stack<int> stk;
        int len = tokens.size();
        for (int i = 0; i < len; ++i)
        {
            string str = tokens[i];
            if (isNumber(str))
            {

                stk.push(atoi(str.c_str()));
            }
            else
            {
                int a = stk.top();
                stk.pop();
                int b = stk.top();
                stk.pop();
                switch (str[0])
                {
                case '+':
                    stk.push(b + a);
                    break;
                case '-':
                    stk.push(b - a);
                    break;
                case '*':
                    stk.push(b * a);
                    break;
                case '/':
                    stk.push(b / a);
                    break;
                }
            }
        }
        return stk.top();
    }
};
```

### B

```c
class Solution
{
public:
    int evalRPN(vector<string> &tokens)
    {
        stack<int> sp;
        int n = tokens.size();
        for (int i = 0; i < n; i++)
        {
            if (tokens[i] == "+")
            {
                int x = sp.top();
                sp.pop();
                int y = sp.top();
                sp.pop();
                sp.push(x + y);
            }
            else if (tokens[i] == "-")
            {
                int x = sp.top();
                sp.pop();
                int y = sp.top();
                sp.pop();
                sp.push(y - x);
            }
            else if (tokens[i] == "*")
            {
                int x = sp.top();
                sp.pop();
                int y = sp.top();
                sp.pop();
                sp.push(x * y);
            }
            else if (tokens[i] == "/")
            {
                int x = sp.top();
                sp.pop();
                int y = sp.top();
                sp.pop();
                sp.push(y / x);
            }
            else
            {
                sp.push(stoi(tokens[i]));
            }
        }
        return sp.top();
    }
};
```

### C

```c
class Solution
{
public:
    int evalRPN(vector<string> &tokens)
    {
        stack<int> num;
        for (int i = 0; i < tokens.size(); ++i)
        {
            if (tokens[i] == "+" || tokens[i] == "-" || tokens[i] == "*" || tokens[i] == "/")
            {
                int j;
                int a = num.top();
                num.pop();
                int b = num.top();
                num.pop();
                if (tokens[i] == "+")
                    j = b + a;
                else if (tokens[i] == "-")
                    j = b - a;
                else if (tokens[i] == "*")
                    j = b * a;
                else
                    j = b / a;
                num.push(j);
            }
            else
            {
                num.push(stoi(tokens[i]));
            }
        }
        return num.top();
    }
};
```
