# 大数乘法

对于32位字长的机器，大约超过20亿，用int类型就无法表示了，我们可以选择int64类型，但无论怎样扩展，固定的整数类型总是有表达的极限！如果对超级大整数进行精确运算呢？一个简单的办法是：仅仅使用现有类型，但是把大整数的运算化解为若干小整数的运算，即所谓：“分块法”。

![](https://img-blog.csdn.net/20160125091111485)  
上图表示了分块乘法的原理。可以把大数分成多段（此处为2段）小数，然后用小数的多次运算组合表示一个大数。可以根据int的承载能力规定小块的大小，比如要把int分成2段，则小块可取10000为上限值。注意，小块在进行纵向累加后，需要进行进位校正。

请从以下四个选项中选择正确答案，填补在空白处，使得代码能运行后能产生正确的结果。

```c
#include <bits/stdc++.h>
using namespace std;

void bigmul(int x, int y, int r[])
{
    int base = 10000;
    int x2 = x / base;
    int x1 = x % base;
    int y2 = y / base;
    int y1 = y % base;

    int n1 = x1 * y1;
    int n2 = x1 * y2;
    int n3 = x2 * y1;
    int n4 = x2 * y2;

    r[3] = n1 % base;
    r[2] = n1 / base + n2 % base + n3 % base;
    r[1] = __________________;
    r[0] = n4 / base;

    r[1] += r[2] / base;
    r[2] = r[2] % base;
    r[0] += r[1] / base;
    r[1] = r[1] % base;
}

int main(int argc, char *argv[])
{
    int x[] = {0, 0, 0, 0};

    bigmul(87654321, 12345678, x);

    printf("%d%d%d%d\n", x[0], x[1], x[2], x[3]);

    return 0;
}
```

## aop

### before

```c

```

### after

```c

```

## 答案

```c
n2 / base + n3 / base + n4 % base
```
## 选项


### A

```c
n2 % base + n3 / base + n4 / base
```

### B

```c
n2 / base + n3 % base + n4 / base
```

### C

```c
n2 / base + n3 / base + n4 / base
```
