# 四平方和

四平方和定理，又称为拉格朗日定理：

每个正整数都可以表示为至多4个正整数的平方和。  

如果把0包括进去，就正好可以表示为4个数的平方和。  

比如：

```
5 = 0^ 2 + 0^ 2 + 1^ 2 + 2^2
7 = 1^ 2 + 1^ 2 + 1^ 2 + 2^2
（^符号表示乘方的意思）
```

对于一个给定的正整数，可能存在多种平方和的表示法。  

要求你对4个数排序：  

```
0 <= a <= b <= c <= d
```

并对所有的可能表示法按 a,b,c,d 为联合主键升序排列，最后输出第一个表示法  

程序输入为一个正整数N (N<5000000)  

要求输出4个非负整数，按从小到大排序，中间用空格分开  

例如，输入：

```
5
```

则程序应该输出：

```
0 0 1 2
```

再例如，输入：

```
12
```

则程序应该输出：

```
0 2 2 2
```

再例如，输入：

```
773535
```

则程序应该输出：

```
1 1 267 838
```

以下程序实现了这一功能，请你补全空白处内容：

```c
#include <bits/stdc++.h>
using namespace std;

typedef long long LL;
const int MAXN = 2500010;
struct Node
{
    int s, c, d;
    bool operator<(const Node &t) const
    {
        if (s != t.s)
            return s < t.s;
        if (c != t.c)
            return c < t.c;
        return d < t.d;
    }
} sum[MAXN];
int n, m;
int main()
{
    cin >> n;
    for (int c = 0; c * c <= n; c++)
        for (int d = c; c * c + d * d <= n; d++)
            sum[m++] = {c * c + d * d, c, d};
    sort(sum, sum + m);
    for (int a = 0; a * a <= n; a++)
    {
        for (int b = 0; a * a + b * b <= n; b++)
        {
            int t = n - a * a - b * b;
            int l = 0, r = m - 1;
            while (l < r)
            {
                __________________
                if (sum[mid].s >= t)
                    r = mid;
                else
                    l = mid + 1;
            }

            if (sum[l].s == t)
            {
                printf("%d %d %d %d", a, b, sum[l].c, sum[l].d);
                return 0;
            }
        }
    }
    return 0;
}
```

## aop

### before

```c

```

### after

```c

```

## 答案

```c
int mid = l + r >> 1;
```

## 选项

### A

```c
int mid = l + (r >> 1);
```

### B

```c
int mid = l + r;
```

### C

```c
int mid = l + r + 1;
```
