# 合并两个有序数组

<p>给你两个有序整数数组 <code>nums1</code><em> </em>和 <code>nums2</code>，请你将 <code>nums2</code><em> </em>合并到 <code>nums1</code><em> </em>中<em>，</em>使 <code>nums1</code><em> </em>成为一个有序数组。</p><p>初始化 <code>nums1</code> 和 <code>nums2</code> 的元素数量分别为 <code>m</code> 和 <code>n</code><em> </em>。你可以假设 <code>nums1</code><em> </em>的空间大小等于 <code>m + n</code>，这样它就有足够的空间保存来自 <code>nums2</code> 的元素。</p><p> </p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>nums1 = [1,2,3,0,0,0], m = 3, nums2 = [2,5,6], n = 3<strong><br />输出：</strong>[1,2,2,3,5,6]</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>nums1 = [1], m = 1, nums2 = [], n = 0<strong><br />输出：</strong>[1]</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>nums1.length == m + n</code></li>	<li><code>nums2.length == n</code></li>	<li><code>0 <= m, n <= 200</code></li>	<li><code>1 <= m + n <= 200</code></li>	<li><code>-10<sup>9</sup> <= nums1[i], nums2[i] <= 10<sup>9</sup></code></li></ul>
<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    vector<int> nums1 = {1, 2, 3, 0, 0, 0};
    int m = 3;
    vector<int> nums2 = {2, 5, 6};
    int n = 3;
    sol.merge(nums1, m, nums2, n);
    for (auto i : nums1)
        cout << i << " ";

    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    void merge(vector<int> &nums1, int m, vector<int> &nums2, int n)
    {
        int i = m - 1;
        int j = n - 1;
        int k = m + n - 1;
        while (i > 0 && j > 0)
        {
            if (nums1[i] > nums2[j])
            {
                nums1[k--] = nums1[i--];
            }
            else
            {
                nums1[k--] = nums2[j--];
            }
        }
        return;
    }
};
```

## 选项


### A

```cpp
class Solution
{
public:
    void merge(vector<int> &nums1, int m, vector<int> &nums2, int n)
    {
        int sum = m + n;
        int pos = 0;
        if (n < 1)
            ;
        else
        {
            for (int i = 0; i < sum && n; i++)
            {
                if (nums2[pos] <= nums1[i] || i >= m)
                {
                    for (int k = nums1.size() - 1; k > i; k--)
                    {
                        nums1[k] = nums1[k - 1];
                    }
                    nums1[i] = nums2[pos];
                    pos++;
                    n--;
                    m++;
                }
            }
        }
    }
};
```

### B

```cpp
class Solution
{
public:
    void merge(vector<int> &nums1, int m, vector<int> &nums2, int n)
    {
        int sum = m + n;
        int k = 0;
        for (int i = m; i < sum; i++)
        {
            nums1[i] = nums2[k];
            k++;
        }
        sort(nums1.begin(), nums1.end());
    }
};
```

### C

```cpp
class Solution
{
public:
    static bool cmp(const int &a, const int &b)
    {
        return a < b;
    }
    void merge(vector<int> &nums1, int m, vector<int> &nums2, int n)
    {
        int sum = m + n;
        int k = 0;
        for (int i = m; i < sum; i++)
        {
            nums1[i] = nums2[k];
            k++;
        }
        sort(nums1.begin(), nums1.end(), cmp);
    }
};
```
