#include <cstdio>
#include <algorithm>
#include <set>
using namespace std;

typedef long long LL;
set<int> all;

bool isPrimt(LL t)
{ //判断是否是素数
    for (int i = 2; i < t / 2; ++i)
    {
        if (t % i == 0)
            return false;
    }
    return true;
}

int f(LL a[], int n)
{ //寻找长度为10的等差素数列
    for (int i = 0; i < n; ++i)
    { //枚举首项
        LL first = a[i];
        for (int delta = 1; delta < a[n - 1] - first; ++delta)
        { //枚举公差
            int m = first;
            for (int j = 1; j < 10; ++j)
            { //枚举个数
                m += delta;
                if (all.find(m) == all.end())
                    break; //m不是素数
                if (m > a[n - 1])
                    break;
                if (j == 9) //已经找了10项
                    return delta;
            }
        }
    }
    return -1;
}
const int N = 5000;

int main()
{
    LL a[N];

    a[0] = 2;
    a[1] = 3;
    all.insert(2);
    all.insert(3);

    int index = 2;
    LL t = 5;
    while (index < N)
    { //枚举5000位素数表
        if (isPrimt(t))
        {
            a[index++] = t;
            all.insert(t);
        }
        t++;
    }

    printf("%d\n", f(a, N));
    return 0;
}