# 第几个幸运数

到x星球旅行的游客都被发给一个整数，作为游客编号。  

x星的国王有个怪癖，他只喜欢数字3,5和7。  

国王规定，游客的编号如果只含有因子：3,5,7,就可以获得一份奖品。  

我们来看前10个幸运数字是：  

```json
3 5 7 9 15 21 25 27 35 45  
```

因而第11个幸运数字是：49  

小明领到了一个幸运数字 59084709587505，他去领奖的时候，人家要求他准确地说出这是第几个幸运数字，否则领不到奖品。

请你帮小明计算一下，59084709587505是第几个幸运数字。

以下选项<span style="color:red">错误</span>的是？

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c

```

## 答案

```c
typedef long long LL;
const LL MAX = 59084709587505;
int main()
{
    int a[3] = {3, 5, 7};
    LL tou = 1;
    set<LL> s;
    while (true)
    {

        for (int i = 0; i < 3; i++)
        {
            LL tt = tou * a[i];
            if (tt <= MAX)
                s.insert(tt);
        }
        tou = s.upper_bound(tou);
        if (tou >= MAX)
            break;
    }
    cout << s.size() << endl;
    return 0;
}
```
## 选项


### A

```c
#define LL long long
LL maxs = 59084709587505;
set<LL> q;
int main()
{
    q.insert(3);
    q.insert(5);
    q.insert(7);
    set<LL>::iterator it;
    it = q.begin();
    LL mid;
    while (*it <= maxs)
    {
        mid = *it;
        q.insert(mid * 3);
        q.insert(mid * 5);
        q.insert(mid * 7);
        it++;
    }
    int num = 0;
    for (it = q.begin(); it != q.end(); it++)
    {
        if (*it <= maxs)
            num++;
    }
    cout << num;
    return 0;
}
```

### B

```c
typedef long long LL;
const LL Max = 59084709587505;
int a[3] = {3, 5, 7};

void Find(LL Max)
{
    set<LL> se;
    LL t = 1;
    while (1)
    {
        for (int i = 0; i < 3; ++i)
        {
            LL tt = t * a[i];
            if (tt <= Max)
                se.insert(tt);
        }
        t = *se.upper_bound(t);
        if (t == Max)
            break;
    }
    cout << se.size() << endl;
}
int main(void)
{

    Find(Max);

    return 0;
}
```

### C

```c
int main()
{
    set<long long> st;
    priority_queue<long long, vector<long long>, greater<long long>> pq;
    const int ok[3] = {3, 5, 7};
    st.insert(1);
    pq.push(1);
    int times = 0;
    while (true)
    {
        long long lucky = pq.top();
        pq.pop();
        if (lucky == 59084709587505)
        {
            cout << times << endl;
            return 0;
        }
        times++;
        for (int i = 0; i < 3; i++)
        {
            long long b = lucky * ok[i];
            if (!st.count(b))
            {
                st.insert(b);
                pq.push(b);
            }
        }
    }
    return 0;
}
```
