# 神奇算式

由4个不同的数字，组成的一个乘法算式，它们的乘积仍然由这4个数字组成。

比如： 

```json
210 x 6 = 1260 
8 x 473 = 3784
27 x 81 = 2187 
```

都符合要求。  

如果满足乘法交换律的算式算作同一种情况，那么，包含上边已列出的3种情况，一共有多少种满足要求的算式。

以下选项<span style="color:red">错误</span>的是？


## 答案

```c
int vis[10];
int ans = 0;
bool s(int i)
{
    while (i)
    {
        if (vis[i % 10] == 1)
            return false;
        else
        {
            vis[i % 10] = 1;
            i /= 10;
        }
    }
    return true;
}
int main()
{
    for (int i = 1; i < 999; i++)
    {
        for (int j = 1; j < 999; j++)
        {
            memset(vis, 0, sizeof(vis));
            if (s(i) && s(j))
            {
                int k = i * j;
                if (k > 9999 || k < 1000)
                    continue;

                int t = k;
                while (k)
                {
                    if (vis[k % 10] == 1)
                    {
                        vis[k % 10]++;

                        k /= 10;
                    }
                    else
                        break;
                }
                if (k == 0 && vis[0] != 1 && vis[1] != 1 && vis[2] != 1 && vis[3] != 1 && vis[4] != 1 && vis[5] != 1 && vis[6] != 1 && vis[7] != 1 && vis[8] != 1 && vis[9] != 1)
                {
                    ans++;
                }
            }
        }
    }
    cout << ans << endl;
    return 0;
}
```

## 选项

### A

```c
bool isOk(int result, int t1, int t2)
{
    bool flag1[10] = {0}, flag2[10] = {0};
    int i, rNum[4], num[4];
    for (i = 0; i < 4; i++)
    {
        rNum[i] = result % 10;
        result /= 10;
        if (flag1[rNum[i]])
            return false;
        flag1[rNum[i]] = true;
    }
    i = 0;
    while (t1 > 0)
    {
        num[i] = t1 % 10;
        t1 /= 10;
        if (flag2[num[i]])
            return false;
        flag2[num[i]] = true;
        i++;
    }
    while (t2 > 0)
    {
        num[i] = t2 % 10;
        t2 /= 10;
        if (flag2[num[i]])
            return false;
        flag2[num[i]] = true;
        i++;
    }
    if (i != 4)
        return false;
    for (i = 0; i < 10; i++)
        if (flag1[i] != flag2[i])
            return false;
    return true;
}

int main()
{
    int i, j, count = 0;
    for (i = 1000; i < 10000; i++)
    {

        for (j = 1; j * j <= i; j++)
            if (!(i % j) && isOk(i, j, i / j))
            {
                count++;
            }
    }
    cout << count << endl;

    return 0;
}
```

### B

```c
int main()
{
    int v[5], i;
    int ans = 0;
    for (i = 1023; i <= 9876; i++)
    {
        v[0] = i / 1000;
        v[1] = i / 10 % 10;
        v[2] = i / 100 % 10;
        v[3] = i % 10;
        int flag1 = 0, flag2 = 0;
        if (v[0] != v[1] && v[0] != v[2] && v[0] != v[3] && v[1] != v[2] && v[1] != v[3] && v[2] != v[3])
        {
            do
            {
                if (flag1 != 3 && (v[0] * 100 + v[1] * 10 + v[2]) * v[3] == i)
                {
                    flag1 = 1;
                    ans++;
                }
                else if (flag2 != 2 && (v[0] * 10 + v[1]) * (v[2] * 10 + v[3]) == i)
                {
                    flag2 = 2;
                    ans++;
                }
                else if (flag1 != 1 && v[0] * (v[1] * 100 + v[2] * 10 + v[3]) == i)
                {
                    flag1 = 3;
                    ans++;
                }
            } while (next_permutation(v, v + 4));
        }
    }
    cout << ans;
    return 0;
}
```

### C

```c
#define MAX_N 1005

bool judge1(int n)
{
    int ans = 0;
    while (n)
    {
        ans++;
        n /= 10;
    }
    if (ans == 4)
        return true;
    return false;
}

bool judge2(int i, int j)
{
    int s1 = 0, s2 = 0;
    int ss1 = 1, ss2 = 1;
    int tmp = i * j;
    bool flag1 = true, flag2 = true;
    while (tmp)
    {
        s1 += tmp % 10;
        if (tmp % 10 == 0)
            flag1 = false;
        else
            ss1 *= tmp % 10;
        tmp /= 10;
    }
    while (j)
    {
        s2 += j % 10;
        if (j % 10 != 0)
            ss2 *= j % 10;
        else
            flag2 = false;
        j /= 10;
    }
    while (i)
    {
        s2 += i % 10;
        if (i % 10 != 0)
            ss2 *= i % 10;
        else
            flag2 = false;
        i /= 10;
    }
    if (s1 == s2 && ss1 == ss2 && flag1 && flag2)
        return true;
    else if ((!flag1 && !flag2) && s1 == s2 && ss1 == ss2)
        return true;
    return false;
}

bool judge3(int i, int j)
{
    int a[4];
    int ans = 0;
    while (i)
    {
        a[ans] = i % 10;
        i /= 10;
        ans++;
    }
    while (j)
    {
        a[ans] = j % 10;
        j /= 10;
        ans++;
    }
    for (i = 0; i < 3; i++)
    {
        for (j = i + 1; j < 4; j++)
            if (a[i] == a[j])
                return false;
    }
    return true;
}

int main()
{

    int i, j;
    int ans = 0;
    for (i = 1; i < 10; i++)
    {
        for (j = 123; j < 1000; j++)
        {
            if (judge1(i * j) && judge2(i, j) && judge3(i, j))
                ans++;
        }
    }
    for (i = 10; i < 100; i++)
    {
        for (j = i + 1; j < 100; j++)
        {
            if (judge1(i * j) && judge2(i, j) && judge3(i, j))
                ans++;
        }
    }
    cout << ans;
    return 0;
}
```
